import TopLayerCtrl from "./ctrls/topLayerCtrl";
import {ModuleTypes} from "./types/sceneTypes";

export const getResPath = () => window['resPath'] || '';
export const getSkinPath = (key) => `resource/skins/${key}Skin.exml`


export function showShare(callback) {
    let opts = {
        shareTitle: window['shareTitle'] || '掌上游乐园，签到兑好礼！',
        shareContent: window['shareText'] || '100%得好礼！华为耳机，爱奇艺、优酷会员，大牌权益等你来拿！',
        shareUrl: window['shareTextUrl'] || `https://activity.m.duiba.com.cn/projectx/${window['CFG'].projectId}/f0afd7159.html?appKey=3axkmGPX35ZgonZBxkLGwAemRpXm&openBs=openbs`,
        shareThumbnail: window['shareThumbnail'] || 'https://yun.duiba.com.cn/aurora/assets/acfbfca1f8a88c95ecea7299d6acdab4cd924827.png'
    }
    console.log("opts=", opts)
    window["requireShare"](opts, () => {//分享成功
        console.log('分享成功回调')
        callback();
    }, () => {//分享失败
        console.log('分享失败回调')
        TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg: '分享失败！'});
    });
}