import {HtmlTextParser} from './../ctrls/HtmlTextParser';
import Panel from "../views/Panel";
import {NetManager} from "../../libs/tw/manager/NetManager";
import {DataManager} from "../../libs/tw/manager/DataManager";
import {ImageAni} from './ImageAni';
import TopLayerCtrl from '../ctrls/topLayerCtrl';
import {ModuleTypes} from '../types/sceneTypes';
import {GDispatcher} from '../../libs/tc/util/GDispatcher';
import {NetName} from '../../libs/tw/enum/NetName';
import PanelCtrl from '../ctrls/panelCtrl';
import {Buried} from '../../libs/tw/util/Buried';

export default class SignSucPanel extends Panel {
    public closeBtn: eui.Button;
    public signDaysTxt: eui.Label;
    public redMapleTxt: eui.Label;
    public tomSignTxt: eui.Label;
    public shareBtn: eui.Button;
    public lightImg: eui.Image;

    private sData;

    // public shareTxt: eui.Label;


    public get skinKey() {
        return 'SignSucPanel'
    }

    public get groupName() {
        return 'signsuc_panel'
    }

    constructor(data: any) {
        super(data);
        this.sData = data.sData;
    }

    onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
        this.showAct();
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.shareBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_shareBtn, this);
    }

    removeEvents(): void {
        super.removeEvents();
        this.shareBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_shareBtn, this);
    }

    onTap_shareBtn() {
        PanelCtrl.instance.btnDelay(this.shareBtn);
        let startDpmOut = Buried.connectDpm(110, 7, 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);
        NetManager.ins.clickLog(exposure);
        //进入分享流程
        // 这是广州光大银行的
        let opts = {
            shareTitle: window['shareTitle'] ? window['shareTitle'] : '掌上游乐园，签到兑好礼！',
            shareContent: window['shareText'] ? window['shareText'] : '100%得好礼！华为耳机，爱奇艺、优酷会员，大牌权益等你来拿！',
            shareUrl: window['shareTextUrl'] ? window['shareTextUrl'] : `https://activity.m.duiba.com.cn/projectx/${window['CFG'].projectId}/f0afd7159.html?appKey=3axkmGPX35ZgonZBxkLGwAemRpXm&openBs=openbs`,
            shareThumbnail: window['shareThumbnail'] || 'https://yun.duiba.com.cn/aurora/assets/acfbfca1f8a88c95ecea7299d6acdab4cd924827.png'
        }
        console.log("opts=", opts)
        window["requireShare"](opts, () => {//分享成功
            console.log('分享成功回调')
            NetManager.ins.shareData((success) => {
                if (success) {
                    GDispatcher.dispatchEvent('refreshMoney');
                    let data = DataManager.ins.getData(NetName.SHARE).data;
                    TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg: '分享成功 +' + data.prizeAmount + '稻穗'});
                } else {
                    PanelCtrl.instance.show(ModuleTypes.EXMSG_PANEL);
                }

                this.hidePanel();
            });
        }, () => {//分享失败
            console.log('分享失败回调')
            TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg: '分享失败！'});
        });
    }


    private onLoad(): void {
        let startDpmOut = Buried.connectDpm(110, 7, 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.showLog(exposure);

        // setTimeout(() => {    
        if (this.lightImg) {
            egret.Tween.get(this.lightImg, {loop: true}).to({rotation: 360}, 5000);
        }
        // }, 500);

        if (this.sData) {
            //根据数据
            let day = this.sData.serialDays;
            if (this.sData.serialDays > 99) {
                day = '99+';
            }
            this.signDaysTxt.text = "已连续签到" + day + "天";
            this.redMapleTxt.text = "稻穗+" + this.sData.prizeAmount;
            this.tomSignTxt.text = "明天签到 稻穗+" + this.sData.tomorrowPrizeAmount;
            this.shareBtn.label = '分享获得' + this.sData.sharePrizeAmount + '稻穗';

        }

        //动画
        var arr = []
        for (var i = 1; i <= 11; i++) {
            arr.push("rayAni" + i + "_png");
        }
        var rayAni = new ImageAni(arr);
        this.panelGroup.addChild(rayAni)
        rayAni.x = 125;
        rayAni.y = 175;
        rayAni.play();
        rayAni.touchEnabled = false;
    }


}