import { Data } from "../Data";
import { IPetToyData } from "./IPetToyData";

export class PetHomeInfoData extends Data {
    /**
     * 宠物id
     */
    public petId: number;

    /**
     * 当前状态（1:正常 2:外出 3:吃饭 4:学习 5:喝水 6:睡觉）
     */
    public status = 0;

    /**
     * 状态过期倒计时（单位：分钟，目前只针对吃饭状态有此值）
     */
    public leftMinutes:number=0;

    /**
     * 是否是吃饱状态
     */
    public isFull: boolean;

    /**
     * 宠物名称
     */
    public petName = "";

    /**
     * 宠物等级
     */
    public petLevel = 0;

    /**
     * 饲养员拥有食物量
     */
    public foodNum = 0;

    /**
     * 食物名称
     */
    public foodName = "";

    /**
     * 每次喂养食物数量	
     */
    public feedLimit = 10;

    /**
     * 宝箱插件id
     */
    public awardPluginId = 0;

    /**
     * 外出奖励（-1:自定义奖励 0:无奖励 1：粮食奖励）
     */
    public travelRewardType = 0;

    /**
     * 外出奖励个数(针对粮食奖励)
     */
    public travelRewardNum = 0;

    /**
     * 宠物正在使用的道具数据
     */
    public toy: IPetToyData[] = [];

    /**
     * 等级奖励插件ID
     */
    public levelRewardPluginId:number;
    
    /**
     * 当前经验值
     */
    public petExp:number=0;
    
    /**
     * 当前级别初始的经验值
     */
    public currentLevelExp:number=0;
    
    /**
     * 下个级别初始的经验值	
     */
    public nextLevelExp:number=0;

    /**
     * 粮食存储上限
     */
    public foodStoreLimit:number=0;

    /**
     * 当前状态总持续时间
     */
    public statusTotalTime:number=0;

    /**
     * 当前状态剩余时间，单位秒	
     */
    public statusRemainingTime:number=0;

    /**
     * 食物列表		
     */
    public foodList:any;

    /**
     * 食物列表携程
     */
    public foodPileList:any[];
    


    public update(result: any): void {
        if (!result) {
            return;
        }
        super.update(result);

        let result2;
        if (result.data) {
            result2 = result.data;
        }
        if(result2){
            if (result2.petId) {
                this.petId = result2.petId;
            }
            if (result2.status) {
                this.status = result2.status;
            }
            if (result2.leftMinutes) {
                this.leftMinutes = result2.leftMinutes;
            }
            if (result2.isFull) {
                this.isFull = result2.isFull;
            }
            if (result2.petName) {
                this.petName = result2.petName;
            }
            if (result2.petLevel) {
                this.petLevel = result2.petLevel;
            }
            if (result2.foodNum) {
                this.foodNum = result2.foodNum;
            }
            if (result2.foodName) {
                this.foodName = result2.foodName;
            }
            if (result2.feedLimit) {
                this.feedLimit = result2.feedLimit;
            }
            if (result2.awardPluginId) {
                this.awardPluginId = result2.awardPluginId;
            }
            if (result2.travelRewardType) {
                this.travelRewardType = result2.travelRewardType;
            }
            if (result2.travelRewardNum) {
                this.travelRewardNum = result2.travelRewardNum;
            }
            this.toy = result2.toy;

            if(result2.levelRewardPluginId){
                this.levelRewardPluginId = result2.levelRewardPluginId;
            }
            if(result2.petExp){
                this.petExp = result2.petExp;
            }
            if(result2.currentLevelExp){
                this.currentLevelExp = result2.currentLevelExp;
            }
            if(result2.nextLevelExp){
                this.nextLevelExp = result2.nextLevelExp;
            }
            if(result2.foodStoreLimit){
                this.foodStoreLimit = result2.foodStoreLimit;
            }
            if(result2.statusTotalTime){
                this.statusTotalTime = result2.statusTotalTime;
            }
            if(result2.statusRemainingTime){
                this.statusRemainingTime = result2.statusRemainingTime;
            }
            if(result2.foodList){
                this.foodList = result2.foodList;
            }

            if(result2.foodPileList){
                this.foodPileList = result2.foodPileList
            }
        }
    }
}