"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var ComponentBase_1 = require("../components/ComponentBase");
var Loading_1 = require("../loading/Loading");
var Panel = (function (_super) {
    __extends(Panel, _super);
    function Panel(data, hasMask) {
        if (hasMask === void 0) { hasMask = true; }
        var _this = _super.call(this, data) || this;
        _this.hasMask = hasMask;
        return _this;
    }
    /**
     *
     * @param hasColor true 有颜色  false为没有颜色
     */
    Panel.prototype.setMask = function () {
        if (!this.pMask) {
            var rate = document.body.clientHeight / document.body.clientWidth;
            this.pMask = new egret.Shape();
            this.pMask.graphics.beginFill(0, 0.8);
            this.pMask.graphics.drawRect(0, 0, 750, 1624); //750 * rate);
            this.pMask.graphics.endFill();
            this.addChildAt(this.pMask, 0);
            this.pMask.touchEnabled = false;
        }
    };
    Panel.prototype.setShowAct = function () {
        this.alpha = 0;
        // this.y = document.body.clientHeight;
        // this.scaleY = 0;
        egret.Tween.get(this).to({ alpha: 1 }, 300);
    };
    Panel.prototype.initEvents = function () {
        var _this = this;
        if (this.closeBtns && this.closeBtns.length > 0) {
            this.closeBtns.forEach(function (btn) { if (btn)
                btn.addEventListener(egret.TouchEvent.TOUCH_TAP, _this.onTouchTap, _this); });
        }
        if (this.confirmBtns && this.confirmBtns.length > 0) {
            this.confirmBtns.forEach(function (btn) { if (btn)
                btn.addEventListener(egret.TouchEvent.TOUCH_TAP, _this.onTouchTap, _this); });
        }
        // if(this.creditsOutBtns && this.creditsOutBtns.length > 0){
        //     this.creditsOutBtns.forEach(
        //         btn => { if(btn) btn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.creditsOut, this) } 
        //     )
        // }
    };
    Panel.prototype.removeEvents = function () {
        var _this = this;
        if (this.closeBtns && this.closeBtns.length > 0) {
            this.closeBtns.forEach(function (btn) { if (btn)
                btn.removeEventListener(egret.TouchEvent.TOUCH_TAP, _this.onTouchTap, _this); });
        }
        if (this.confirmBtns && this.confirmBtns.length > 0) {
            this.confirmBtns.forEach(function (btn) { if (btn)
                btn.removeEventListener(egret.TouchEvent.TOUCH_TAP, _this.onTouchTap, _this); });
        }
        // if(this.creditsOutBtns && this.creditsOutBtns.length > 0){
        //     this.creditsOutBtns.forEach(
        //         btn => { if(btn) btn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.creditsOut, this) } 
        //     )
        // }
    };
    Panel.prototype.onSkinComplete = function () {
        _super.prototype.onSkinComplete.call(this);
        Loading_1.default.instace.hide();
        this.setMask();
        if (!this.hasMask) {
            this.pMask.alpha = 0;
        }
        this.setShowAct();
    };
    Object.defineProperty(Panel.prototype, "closeBtns", {
        get: function () { return [this['closeBtn']]; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Panel.prototype, "confirmBtns", {
        get: function () { return [this['confirmBtn']]; },
        enumerable: true,
        configurable: true
    });
    // protected get creditsOutBtns(): eui.Button[] { return [this['creditsOutBtn']] }
    Panel.prototype.onTouchTap = function () {
        this.hidePanel();
    };
    //播放显示动画
    Panel.prototype.showAct = function (callback) {
        if (callback === void 0) { callback = null; }
        if (this.panelGroup) {
            this.panelGroup.touchEnabled = false;
            this.panelGroup.touchChildren = false;
            var aX = this.panelGroup.width * 0.5;
            var aY = this.panelGroup.height * 0.5;
            this.panelGroup.anchorOffsetX = aX;
            this.panelGroup.anchorOffsetY = aY;
            this.panelGroup.x += aX;
            this.panelGroup.y += aY;
            var tweenObj = void 0;
            if (this.panelGroup) {
                this.panelGroup.scaleX = 0;
                this.panelGroup.scaleY = 0;
                tweenObj = { scaleX: 1, scaleY: 1 };
            }
            else {
                this.panelGroup.alpha = 0;
                tweenObj = { alpha: 1 };
            }
            egret.Tween.get(this.panelGroup).to(tweenObj, 300, egret.Ease.backInOut).call(function () {
                if (callback) {
                    callback();
                }
                this.panelGroup.touchEnabled = true;
                this.panelGroup.touchChildren = true;
            }.bind(this));
        }
        else {
            if (callback) {
                callback();
            }
        }
    };
    Panel.prototype.hidePanel = function () {
        if (this.panelGroup) {
            egret.Tween.get(this.panelGroup).to({ scaleX: 0, scaleY: 0 }, 200, egret.Ease.sineOut).call(function () {
                this.destroy();
                this.dispatchEvent(new egret.Event('onDestroy'));
            }.bind(this));
        }
        else {
            egret.Tween.get(this).to({ alpha: 0 }, 200, egret.Ease.sineOut).call(function () {
                this.destroy();
                this.dispatchEvent(new egret.Event('onDestroy'));
            }.bind(this));
            // this.destroy();
            // this.dispatchEvent(new egret.Event('onDestroy'));
        }
    };
    Panel.prototype.clearEvent = function () {
        this.destroy();
        this.dispatchEvent(new egret.Event('onDestroy'));
    };
    Panel.prototype.creditsOut = function () {
        this.destroy();
        // this.dispatchEvent(new egret.Event('onCreditsOut'));
    };
    return Panel;
}(ComponentBase_1.default));
exports.default = Panel;
__reflect(Panel.prototype, "\"/Users/zuopeng/DBGitLab/db-game-template/egret/src/views/Panel\".Panel");
//# sourceMappingURL=Panel.js.map