"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var MyProgressBar = (function (_super) {
    __extends(MyProgressBar, _super);
    /**
     *
     * @param lv 等级
     * @param name 狗名
     * @param iconName 资源名
     * @param callBack
     */
    function MyProgressBar(tSpeed, callBack) {
        if (callBack === void 0) { callBack = null; }
        var _this = _super.call(this) || this;
        _this.skinName = 'resource/skins/ui/MyProgressBarSkin.exml';
        _this.tSpeed = tSpeed;
        _this.addEventListener(egret.Event.COMPLETE, _this.onSkinComplete, _this);
        if (_this.skin) {
            _this.onSkinComplete();
        }
        _this.callBack = callBack;
        return _this;
    }
    MyProgressBar.prototype.onSkinComplete = function () {
        this.removeEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);
        this.shape = new egret.Shape();
        this.shape.graphics.beginFill(0);
        this.shape.graphics.drawRoundRect(7, 5, 500, 28, 33, 33);
        this.shape.graphics.endFill();
        this.addChild(this.shape);
        this.barImg.mask = this.shape;
        this.imgSource = 0;
        // this.barVal = 100;
        // let i = 0;
        // setInterval(()=>{
        //     if(i < 100){
        //         i += 10;
        //         this.barVal = i;
        //     }
        // }, 300)
    };
    Object.defineProperty(MyProgressBar.prototype, "imgSource", {
        set: function (idx) {
            this.barImg.source = 'bar' + idx + '_png';
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MyProgressBar.prototype, "barVal", {
        set: function (val) {
            egret.Tween.get(this.barImg).to({ x: -470 * (1 - val / 100) }, this.tSpeed);
            egret.Tween.get(this.barIcon).to({ x: 470 * val / 100 }, this.tSpeed);
            // this.barImg.x = -470 * (1 - val / 100);
            // this.barIcon.x = 470 * val / 100;
        },
        enumerable: true,
        configurable: true
    });
    MyProgressBar.prototype.removeEvent = function () {
    };
    return MyProgressBar;
}(eui.Component));
exports.MyProgressBar = MyProgressBar;
__reflect(MyProgressBar.prototype, "\"/Users/zuopeng/DBGitLab/db-game-template/egret/src/ui/MyProgressBar\".MyProgressBar");
//# sourceMappingURL=MyProgressBar.js.map