"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = require("../views/Panel");
var NetManager_1 = require("../../libs/tw/manager/NetManager");
var DataManager_1 = require("../../libs/tw/manager/DataManager");
var ImageAni_1 = require("./ImageAni");
var topLayerCtrl_1 = require("../ctrls/topLayerCtrl");
var sceneTypes_1 = require("../types/sceneTypes");
var GDispatcher_1 = require("../../libs/tc/util/GDispatcher");
var NetName_1 = require("../../libs/tw/enum/NetName");
var panelCtrl_1 = require("../ctrls/panelCtrl");
var Buried_1 = require("../../libs/tw/util/Buried");
var SignSucPanel = (function (_super) {
    __extends(SignSucPanel, _super);
    function SignSucPanel(data) {
        var _this = _super.call(this, data) || this;
        _this.sData = data.sData;
        return _this;
    }
    Object.defineProperty(SignSucPanel.prototype, "skinKey", {
        // public shareTxt: eui.Label;
        get: function () { return 'SignSucPanel'; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SignSucPanel.prototype, "groupName", {
        get: function () { return 'signsuc_panel'; },
        enumerable: true,
        configurable: true
    });
    SignSucPanel.prototype.onSkinComplete = function () {
        _super.prototype.onSkinComplete.call(this);
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
        this.showAct();
    };
    SignSucPanel.prototype.start = function () {
        this.percentHeight = 100;
    };
    SignSucPanel.prototype.initEvents = function () {
        _super.prototype.initEvents.call(this);
        this.shareBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_shareBtn, this);
    };
    SignSucPanel.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
        this.shareBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_shareBtn, this);
    };
    SignSucPanel.prototype.onTap_shareBtn = function () {
        var _this = this;
        panelCtrl_1.default.instance.btnDelay(this.shareBtn);
        var startDpmOut = Buried_1.Buried.connectDpm(110, 7, 1); // 点击埋点   
        var startDcmOut = Buried_1.Buried.connectDcm(202, 0, 0); // 曝光埋点
        var exposure = Buried_1.Buried.createExposure(startDpmOut, startDcmOut);
        console.log(66666);
        NetManager_1.NetManager.ins.clickLog(exposure);
        //进入分享流程
        var param = {
            "shareTitle": window['shareTitle'] ? window['shareTitle'] : '美好生活上上签',
            "shareTextUrl": window['shareTextUrl'] ? window['shareTextUrl'] : 'https://activity.m.duiba.com.cn/customShare/share?id=3473',
            "shareText": window['shareText'] ? window['shareText'] : '每日一签，奇趣好礼等你拿',
            "sequence": '110',
            "showDialog": 'true',
            "shareAlertTitle": '分享',
            "callback": "shareCallBack" //分享回调方法
        };
        window['shareCallBack'] = function (data) {
            var issuccess;
            var u = navigator.userAgent; //, app = navigator.appVersion;
            var android = u.indexOf('Android') > -1 || u.indexOf('Linux') > -1; //g
            var iphone = !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/); //ios终端
            if (android) {
                if (data == '0') {
                    issuccess = true;
                }
                else {
                    issuccess = false;
                }
            }
            if (iphone) {
                if (data == '1') {
                    issuccess = true;
                }
                else {
                    issuccess = false;
                }
            }
            if (issuccess) {
                //alert("分享成功");
                console.log("分享成功");
                NetManager_1.NetManager.ins.shareData(function (success) {
                    if (success) {
                        GDispatcher_1.GDispatcher.dispatchEvent('refreshMoney');
                        var data_1 = DataManager_1.DataManager.ins.getData(NetName_1.NetName.SHARE).data;
                        topLayerCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.TOAST_PANEL, { msg: '分享成功 +' + data_1.prizeAmount + '稻穗' });
                    }
                    else {
                        panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.EXMSG_PANEL);
                    }
                    _this.hidePanel();
                });
            }
            else {
                //alert("分享失败");
                console.log("分享失败");
                topLayerCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.TOAST_PANEL, { msg: '分享失败！' });
            }
        };
        console.log('ThirdApp', window['ThirdApp']);
        window['ThirdApp'].webviewShare(param);
    };
    SignSucPanel.prototype.onLoad = function () {
        var startDpmOut = Buried_1.Buried.connectDpm(110, 7, 1); // 点击埋点   
        var startDcmOut = Buried_1.Buried.connectDcm(202, 0, 0); // 曝光埋点
        var exposure = Buried_1.Buried.createExposure(startDpmOut, startDcmOut);
        NetManager_1.NetManager.ins.showLog(exposure);
        // setTimeout(() => {    
        if (this.lightImg) {
            egret.Tween.get(this.lightImg, { loop: true }).to({ rotation: 360 }, 5000);
        }
        // }, 500);
        if (this.sData) {
            //根据数据
            var day = this.sData.serialDays;
            if (this.sData.serialDays > 99) {
                day = '99+';
            }
            this.signDaysTxt.text = "已连续签到" + day + "天";
            this.redMapleTxt.text = "稻穗+" + this.sData.prizeAmount;
            this.tomSignTxt.text = "明天签到 稻穗+" + this.sData.tomorrowPrizeAmount;
            this.shareBtn.label = '分享获得' + this.sData.sharePrizeAmount + '稻穗';
        }
        //动画
        var arr = [];
        for (var i = 1; i <= 11; i++) {
            arr.push("rayAni" + i + "_png");
        }
        var rayAni = new ImageAni_1.ImageAni(arr);
        this.panelGroup.addChild(rayAni);
        rayAni.x = 125;
        rayAni.y = 175;
        rayAni.play();
        rayAni.touchEnabled = false;
    };
    return SignSucPanel;
}(Panel_1.default));
exports.default = SignSucPanel;
__reflect(SignSucPanel.prototype, "\"/Users/zuopeng/DBGitLab/db-game-template/egret/src/panels/SignSucPanel\".SignSucPanel");
//# sourceMappingURL=SignSucPanel.js.map