"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = require("../views/Panel");
var DataManager_1 = require("../../libs/tw/manager/DataManager");
var NetManager_1 = require("../../libs/tw/manager/NetManager");
var Buried_1 = require("../../libs/tw/util/Buried");
var NetName_1 = require("../../libs/tw/enum/NetName");
var PrizePanel = (function (_super) {
    __extends(PrizePanel, _super);
    // public get groupName() { return 'prize_panel' }
    function PrizePanel(data) {
        return _super.call(this, data) || this;
    }
    Object.defineProperty(PrizePanel.prototype, "skinKey", {
        get: function () { return 'PrizePanel'; },
        enumerable: true,
        configurable: true
    });
    PrizePanel.prototype.onSkinComplete = function () {
        _super.prototype.onSkinComplete.call(this);
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
        this.showAct(function () {
        }.bind(this));
    };
    PrizePanel.prototype.start = function () {
        this.percentHeight = 100;
    };
    PrizePanel.prototype.initEvents = function () {
        _super.prototype.initEvents.call(this);
        this.useBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ok, this);
    };
    PrizePanel.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
        this.useBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ok, this);
    };
    PrizePanel.prototype.onLoad = function () {
        var startDpmOut = Buried_1.Buried.connectDpm(110, 10, 1); // 点击埋点   
        var startDcmOut = Buried_1.Buried.connectDcm(202, 0, 0); // 曝光埋点
        var exposure = Buried_1.Buried.createExposure(startDpmOut, startDcmOut);
        NetManager_1.NetManager.ins.showLog(exposure);
        this.mdata = DataManager_1.DataManager.ins.getData(NetName_1.NetName.EXCHANGE_PROJECT).data;
        this.prizeName.text = this.mdata.name;
        this.prizeImage.source = this.mdata.icon;
        // switch (this.lottery.type) {
        //     case LotteryType.VIRTUAL:
        //     case LotteryType.OBJECT:
        //     case LotteryType.ALIPAY:
        //     case LotteryType.PHONEBILL:
        //     case LotteryType.QB:
        //         this.prizeImage.width = 250;
        //         this.prizeImage.height = 250;
        //         break;
        //     case LotteryType.THANKS:
        //         break;
        //     default:
        //         this.prizeImage.width = 520;
        //         this.prizeImage.height = 250;
        //         break;
        // }
    };
    PrizePanel.prototype.onUse = function () {
        // window.location.href = this.mdata.url;
    };
    PrizePanel.prototype.onTap_ok = function (e) {
        var startDpmOut = Buried_1.Buried.connectDpm(110, 10, 1); // 点击埋点   
        var startDcmOut = Buried_1.Buried.connectDcm(202, 0, 0); // 曝光埋点
        var exposure = Buried_1.Buried.createExposure(startDpmOut, startDcmOut);
        NetManager_1.NetManager.ins.clickLog(exposure);
        this.onUse();
        this.onTouchTap();
    };
    return PrizePanel;
}(Panel_1.default));
exports.default = PrizePanel;
__reflect(PrizePanel.prototype, "\"/Users/zuopeng/DBGitLab/db-game-template/egret/src/panels/PrizePanel\".PrizePanel");
//# sourceMappingURL=PrizePanel.js.map