"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = require("../views/Panel");
var NetManager_1 = require("../../libs/tw/manager/NetManager");
var Buried_1 = require("../../libs/tw/util/Buried");
var NoRedMaplePanel = (function (_super) {
    __extends(NoRedMaplePanel, _super);
    function NoRedMaplePanel(data) {
        return _super.call(this, data) || this;
    }
    Object.defineProperty(NoRedMaplePanel.prototype, "skinKey", {
        get: function () { return 'NoRedMaplePanel'; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(NoRedMaplePanel.prototype, "groupName", {
        get: function () { return 'noredmaple_panel'; },
        enumerable: true,
        configurable: true
    });
    NoRedMaplePanel.prototype.onSkinComplete = function () {
        _super.prototype.onSkinComplete.call(this);
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
        this.showAct();
    };
    NoRedMaplePanel.prototype.start = function () {
        this.percentHeight = 100;
    };
    NoRedMaplePanel.prototype.initEvents = function () {
        _super.prototype.initEvents.call(this);
        this.knowBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_knowBtn, this);
    };
    NoRedMaplePanel.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
        this.knowBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_knowBtn, this);
    };
    NoRedMaplePanel.prototype.onTap_knowBtn = function () {
        var startDpmOut = Buried_1.Buried.connectDpm(110, 9, 1); // 点击埋点   
        var startDcmOut = Buried_1.Buried.connectDcm(202, 0, 0); // 曝光埋点
        var exposure = Buried_1.Buried.createExposure(startDpmOut, startDcmOut);
        NetManager_1.NetManager.ins.clickLog(exposure);
        //关闭弹框
        this.hidePanel();
    };
    NoRedMaplePanel.prototype.onLoad = function () {
        var startDpmOut = Buried_1.Buried.connectDpm(110, 9, 1); // 点击埋点   
        var startDcmOut = Buried_1.Buried.connectDcm(202, 0, 0); // 曝光埋点
        var exposure = Buried_1.Buried.createExposure(startDpmOut, startDcmOut);
        NetManager_1.NetManager.ins.showLog(exposure);
    };
    return NoRedMaplePanel;
}(Panel_1.default));
exports.default = NoRedMaplePanel;
__reflect(NoRedMaplePanel.prototype, "\"/Users/zuopeng/DBGitLab/db-game-template/egret/src/panels/NoRedMaplePanel\".NoRedMaplePanel");
//# sourceMappingURL=NoRedMaplePanel.js.map