"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = require("../views/Panel");
var NetManager_1 = require("../../libs/tw/manager/NetManager");
var DataManager_1 = require("../../libs/tw/manager/DataManager");
var panelCtrl_1 = require("../ctrls/panelCtrl");
var NetName_1 = require("../../libs/tw/enum/NetName");
var sceneTypes_1 = require("../types/sceneTypes");
var Loading_1 = require("../loading/Loading");
var GDispatcher_1 = require("../../libs/tc/util/GDispatcher");
var Buried_1 = require("../../libs/tw/util/Buried");
var LotBoxPanel = (function (_super) {
    __extends(LotBoxPanel, _super);
    // public get groupName() { return 'rule_panel' }
    function LotBoxPanel(data) {
        var _this = _super.call(this, data) || this;
        _this.lData = data;
        return _this;
    }
    Object.defineProperty(LotBoxPanel.prototype, "skinKey", {
        get: function () { return 'LotBoxPanel'; },
        enumerable: true,
        configurable: true
    });
    LotBoxPanel.prototype.onSkinComplete = function () {
        _super.prototype.onSkinComplete.call(this);
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
        this.showAct();
    };
    LotBoxPanel.prototype.start = function () {
        this.percentHeight = 100;
    };
    LotBoxPanel.prototype.initEvents = function () {
        _super.prototype.initEvents.call(this);
        this.useBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_useBtn, this);
    };
    LotBoxPanel.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
        this.useBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_useBtn, this);
    };
    LotBoxPanel.prototype.onTap_useBtn = function () {
        var _this = this;
        panelCtrl_1.default.instance.btnDelay(this.useBtn);
        var startDpmOut = Buried_1.Buried.connectDpm(110, 8, 1); // 点击埋点   
        var startDcmOut = Buried_1.Buried.connectDcm(202, 0, 0); // 曝光埋点
        var exposure = Buried_1.Buried.createExposure(startDpmOut, startDcmOut);
        NetManager_1.NetManager.ins.clickLog(exposure);
        this.hidePanel();
        if (!this.data)
            return;
        Loading_1.default.instace.show();
        //消耗稻穗，打开盲盒
        NetManager_1.NetManager.ins.exchangeProject(function (success) {
            if (!success) {
                Loading_1.default.instace.hide();
                var result = DataManager_1.DataManager.ins.getData(NetName_1.NetName.EXCHANGE_PROJECT);
                if (result.code == '530003') {
                    if (_this.lData.blackBoxFlag) {
                        panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.GAMEOVER_PANEL);
                    }
                    else {
                        panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.OUTOFPRIZE_PANEL);
                    }
                }
                else {
                    panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.EXMSG_PANEL);
                }
                return;
            }
            if (_this.lData) {
                console.log(_this.lData.blackBoxFlag);
                console.log(_this.lData);
                if (_this.lData.blackBoxFlag) {
                    GDispatcher_1.GDispatcher.dispatchEvent('refreshMangheBtn');
                    var data = DataManager_1.DataManager.ins.getData(NetName_1.NetName.EXCHANGE_PROJECT).data;
                    if (data.prizeId == 'thanks') {
                        panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.GAMEOVER_PANEL);
                    }
                    else {
                        panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.PRIZE_PANEL);
                    }
                }
                else {
                    _this.lData.item.exchangeBtn.currentState = 'disabled';
                    _this.lData.item.exchangeBtn.touchEnabled = false;
                    panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.EXCHANGESUC_PANEL);
                }
                GDispatcher_1.GDispatcher.dispatchEvent('refreshMoney');
            }
            Loading_1.default.instace.hide();
        }, this.data.prizeId);
    };
    LotBoxPanel.prototype.onLoad = function () {
        var startDpmOut = Buried_1.Buried.connectDpm(110, 8, 1); // 点击埋点   
        var startDcmOut = Buried_1.Buried.connectDcm(202, 0, 0); // 曝光埋点
        var exposure = Buried_1.Buried.createExposure(startDpmOut, startDcmOut);
        NetManager_1.NetManager.ins.showLog(exposure);
        if (this.lData) {
            //盲盒图片
            this.img.source = this.lData.icon;
            if (this.lData.blackBoxFlag) {
                this.titleLb.text = '您将消耗' + this.lData.needAmount + '个稻穗抽\n一个' + this.lData.name;
            }
            else {
                this.titleLb.text = '您将消耗' + this.lData.needAmount + '个稻穗兑换\n' + this.lData.name;
            }
            //根据数据
            this.redMapleTxt.text = "我的稻穗：" + DataManager_1.DataManager.ins.getGameInfoData.totalAmount;
        }
        else {
            //盲盒图片
            this.img.source = "";
            this.titleLb.text = '';
            //根据数据
            this.redMapleTxt.text = "我的稻穗：" + 0;
        }
    };
    return LotBoxPanel;
}(Panel_1.default));
exports.default = LotBoxPanel;
__reflect(LotBoxPanel.prototype, "\"/Users/zuopeng/DBGitLab/db-game-template/egret/src/panels/LotBoxPanel\".LotBoxPanel");
//# sourceMappingURL=LotBoxPanel.js.map