"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = require("../views/Panel");
var NetManager_1 = require("../../libs/tw/manager/NetManager");
var DataManager_1 = require("../../libs/tw/manager/DataManager");
var NetName_1 = require("../../libs/tw/enum/NetName");
var Buried_1 = require("../../libs/tw/util/Buried");
var panelCtrl_1 = require("../ctrls/panelCtrl");
var ExchangeSucPanel = (function (_super) {
    __extends(ExchangeSucPanel, _super);
    // public get groupName() { return 'prize_panel' }
    function ExchangeSucPanel(data) {
        return _super.call(this, data) || this;
    }
    Object.defineProperty(ExchangeSucPanel.prototype, "skinKey", {
        get: function () { return 'ExchangeSucPanel'; },
        enumerable: true,
        configurable: true
    });
    ExchangeSucPanel.prototype.onSkinComplete = function () {
        _super.prototype.onSkinComplete.call(this);
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
        this.showAct(function () {
        }.bind(this));
    };
    ExchangeSucPanel.prototype.start = function () {
        this.percentHeight = 100;
    };
    ExchangeSucPanel.prototype.initEvents = function () {
        _super.prototype.initEvents.call(this);
        this.useBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ok, this);
    };
    ExchangeSucPanel.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
        this.useBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ok, this);
    };
    ExchangeSucPanel.prototype.onLoad = function () {
        var startDpmOut = Buried_1.Buried.connectDpm(110, 11, 1); // 点击埋点   
        var startDcmOut = Buried_1.Buried.connectDcm(202, 0, 0); // 曝光埋点
        var exposure = Buried_1.Buried.createExposure(startDpmOut, startDcmOut);
        NetManager_1.NetManager.ins.showLog(exposure);
        this.mdata = DataManager_1.DataManager.ins.getData(NetName_1.NetName.EXCHANGE_PROJECT).data;
        this.prizeName.text = this.mdata.name;
        this.prizeImage.source = this.mdata.icon;
        // switch (this.lottery.type) {
        //     case LotteryType.VIRTUAL:
        //     case LotteryType.OBJECT:
        //     case LotteryType.ALIPAY:
        //     case LotteryType.PHONEBILL:
        //     case LotteryType.QB:
        //         this.prizeImage.width = 250;
        //         this.prizeImage.height = 250;
        //         break;
        //     case LotteryType.THANKS:
        //         break;
        //     default:
        //         this.prizeImage.width = 520;
        //         this.prizeImage.height = 250;
        //         break;
        // }
    };
    ExchangeSucPanel.prototype.onUse = function () {
        window.location.href = this.mdata.url;
    };
    ExchangeSucPanel.prototype.onTap_ok = function (e) {
        panelCtrl_1.default.instance.btnDelay(this.useBtn);
        var startDpmOut = Buried_1.Buried.connectDpm(110, 11, 1); // 点击埋点   
        var startDcmOut = Buried_1.Buried.connectDcm(202, 0, 0); // 曝光埋点
        var exposure = Buried_1.Buried.createExposure(startDpmOut, startDcmOut);
        NetManager_1.NetManager.ins.clickLog(exposure);
        this.onUse();
        this.onTouchTap();
    };
    return ExchangeSucPanel;
}(Panel_1.default));
exports.default = ExchangeSucPanel;
__reflect(ExchangeSucPanel.prototype, "\"/Users/zuopeng/DBGitLab/db-game-template/egret/src/panels/ExchangeSucPanel\".ExchangeSucPanel");
//# sourceMappingURL=ExchangeSucPanel.js.map