"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var LotteryType_1 = require("../../enum/LotteryType");
var NetManager_1 = require("../../manager/NetManager");
var DataManager_1 = require("./../../manager/DataManager");
var Model_1 = require("./../Model");
/**
 * 兑吧活动领域模型
 */
var ActivityModel = (function (_super) {
    __extends(ActivityModel, _super);
    function ActivityModel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * 插件抽奖
     * @param callback
     * @param plugId
     */
    ActivityModel.prototype.plugDoJoin = function (callback, plugId) {
        var _this = this;
        NetManager_1.NetManager.ins.doJoinPlugDraw(function (success) {
            if (success) {
                _this.getPlugOrderStatus(callback);
            }
            else {
                callback(success);
            }
        }, plugId);
    };
    /**
     * 插件抽奖订单结果
     * @param net
     */
    ActivityModel.prototype.getPlugOrderStatus = function (callback) {
        NetManager_1.NetManager.ins.getPlugOrderStatus(callback, DataManager_1.DataManager.ins.doJoinPlugDrawData.orderId, function () {
            return DataManager_1.DataManager.ins.getPlugOrderStatusData.result == 0;
        });
    };
    Object.defineProperty(ActivityModel.prototype, "plugIsWinning", {
        /**
         * 插件结果弹窗
         */
        get: function () {
            return DataManager_1.DataManager.ins.getPlugOrderStatusData.lottery ? true : false;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * 曝光埋点
     */
    ActivityModel.prototype.showLog = function () {
        //曝光埋点
        if (this.lottery.imgExposure) {
            NetManager_1.NetManager.ins.showLog(this.lottery.imgExposure);
        }
        //如果是福袋还需要推啊曝光
        if (this.lottery.type == "lucky") {
            NetManager_1.NetManager.ins.spmshow(this.exposure);
        }
    };
    Object.defineProperty(ActivityModel.prototype, "optionImgSize", {
        /**
         * 奖品图尺寸
         */
        get: function () {
            var size;
            if (this.lottery.type == LotteryType_1.LotteryType.ALIPAY ||
                this.lottery.type == LotteryType_1.LotteryType.VIRTUAL ||
                this.lottery.type == LotteryType_1.LotteryType.OBJECT) {
                size = 's';
            }
            else {
                size = 'b';
            }
            return size;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ActivityModel.prototype, "optionImg", {
        /**
         * 奖品图片链接
         */
        get: function () {
            return this.lottery.img;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ActivityModel.prototype, "optionName", {
        /**
         * 奖品名字
         */
        get: function () {
            return this.lottery.name;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ActivityModel.prototype, "lottery", {
        /**
         * 奖品数据
         */
        get: function () {
            return;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ActivityModel.prototype, "exposure", {
        /**
         * 福袋埋点数据
         */
        get: function () {
            return;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * 立即使用
     */
    ActivityModel.prototype.onUse = function () {
        if (this.lottery.type == LotteryType_1.LotteryType.COUPON || this.lottery.type == LotteryType_1.LotteryType.LUCKY) {
            window["downloadAppConfig"] =
                {
                    openUrl: this.lottery.openUrl,
                    iosDownloadUrl: this.lottery.iosDownloadUrl,
                    androidDownloadUrl: this.lottery.androidDownloadUrl,
                    confirm: this.lottery.confirm ? this.lottery.confirm : false
                };
            window["downloadApp"]();
            if (this.lottery.type == "lucky") {
                NetManager_1.NetManager.ins.spmclick(this.exposure);
            }
        }
        else {
            window.location.href = this.lottery.link;
        }
    };
    return ActivityModel;
}(Model_1.Model));
exports.ActivityModel = ActivityModel;
__reflect(ActivityModel.prototype, "\"/Users/zuopeng/DBGitLab/db-game-template/egret/libs/tw/model/common/ActivityModel\".ActivityModel");
//# sourceMappingURL=ActivityModel.js.map