"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
// import { ABNetManager, GTime, INetData, GDispatcher } from "duiba-tc";
var TwLang_1 = require("../util/TwLang");
var DataManager_1 = require("./DataManager");
var NetName_1 = require("../enum/NetName");
var ABNetManager_1 = require("../../tc/manager/ABNetManager");
var GTime_1 = require("../../tc/util/GTime");
var GDispatcher_1 = require("../../tc/util/GDispatcher");
// import { IExposureData } from '..';
var NetManager = (function (_super) {
    __extends(NetManager, _super);
    function NetManager() {
        var _this = _super.call(this) || this;
        if (_this.isInit) {
            throw Error(TwLang_1.TwLang.lang_001);
        }
        _this.isInit = true;
        return _this;
    }
    Object.defineProperty(NetManager, "ins", {
        get: function () {
            if (!this.instance) {
                this.instance = new NetManager();
            }
            return this.instance;
        },
        enumerable: true,
        configurable: true
    });
    /**
     *  获取规则
     */
    NetManager.prototype.getRule = function (callback) {
        var net = {
            name: NetName_1.NetName.GAME_RULE,
            uri: '/ngapi/getRule',
            type: 'post',
            dataType: 'html',
            param: {
                id: ''
            },
            callback: callback
        };
        this.send(net);
    };
    //--------------------------------------------插件-----------------------------------------
    /**
     * 插件抽奖
     * @param {number} activityId 插件ID
     */
    NetManager.prototype.doJoinPlugDraw = function (callback, activityId, deductCredits) {
        var net = {
            name: NetName_1.NetName.PLUG_DO_JOIN,
            uri: '/activityPlugDrawInfo/doJoinPlugdraw',
            type: 'post',
            dataType: 'json',
            param: {
                activityId: activityId,
                deductCredits: deductCredits ? deductCredits : false
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 查询插件抽奖订单
     * @param {number} orderId 订单ID
     * @param {number} prizeLevel 开奖等级，暂未开放
     */
    NetManager.prototype.getPlugOrderStatus = function (callback, orderId, pollingCheck, pollingCount, prizeLevel) {
        if (pollingCount === void 0) { pollingCount = 5; }
        var net = {
            name: NetName_1.NetName.PLUG_ORDER_STATUS,
            uri: '/plugin/getOrderStatus',
            type: 'get',
            dataType: 'json',
            param: {
                orderId: orderId
            },
            callback: callback,
            pollingCheck: pollingCheck,
            pollingCount: pollingCount
        };
        this.send(net);
    };
    /**
     * 获取token
     * @param net
     */
    NetManager.prototype.getToken = function (net) {
        var _this = this;
        if (window['getDuibaToken']) {
            window['getDuibaToken'](function (tokenObj) {
                net.param.token = tokenObj.token;
                _this.send(net);
            }, function (key, messageObj) {
                _this.onError(net);
            });
        }
        else {
            this.send(net);
        }
    };
    /**
     * 查询我的奖品记录
     * @param callback
     * @param {number} page 当前页数
     */
    NetManager.prototype.getRecord = function (callback, page) {
        var _this = this;
        var net = {
            name: NetName_1.NetName.GET_RECORD,
            uri: (window['recordUrl'] ? window['recordUrl'] : '') + '/Crecord/getRecord',
            type: 'get',
            dataType: 'json',
            param: {
                page: page
            },
            callback: callback
        };
        var gTime = '?_=' + GTime_1.GTime.getTimestamp();
        var realUrl = net.uri;
        if (realUrl.indexOf('?') != -1) {
            gTime = '&_=' + GTime_1.GTime.getTimestamp();
        }
        //url加参数等特殊需求（例如再玩一次需要在dostart接口的url上加埋点）
        if (net.addUrl) {
            realUrl += net.addUrl;
        }
        window['$'].ajax({
            type: net.type,
            // url: realUrl + gTime,
            url: realUrl,
            dataType: net.dataType,
            data: net.param,
            async: true,
            xhrFields: {
                withCredentials: true
            },
            crossDomain: true,
            cache: false,
            success: function (result) {
                _this.onResponse(net, result);
            },
            error: function (message) {
                _this.onError(net);
            }
        });
    };
    /**
     * 推啊曝光埋点(福袋)
     * @param {IExposureData} exposure
     */
    NetManager.prototype.spmshow = function (exposure) {
        var domain = (exposure.domain ? exposure.domain : '') + '/engine/';
        var net = {
            name: 'spmshow',
            uri: domain + 'spmshow',
            type: 'get',
            dataType: 'jsonp',
            param: exposure,
            callback: null,
            hideMsg: true
        };
        this.send(net);
    };
    /**
     * 推啊点击埋点(福袋)
     * @param {IExposureData} exposure
     */
    NetManager.prototype.spmclick = function (exposure) {
        var domain = (exposure.domain ? exposure.domain : '') + '/engine/';
        var net = {
            name: 'spmclick',
            uri: domain + 'spmclick',
            type: 'get',
            dataType: 'jsonp',
            param: exposure,
            callback: null,
            hideMsg: true
        };
        this.send(net);
    };
    /**
     * 兑吧点击埋点
     * @param {IExposureData} exposure
     */
    NetManager.prototype.clickLog = function (exposure) {
        var net = {
            name: 'clickLog',
            uri: '/log/click',
            type: 'get',
            dataType: 'jsonp',
            param: exposure,
            callback: null,
            hideMsg: true
        };
        this.send(net);
    };
    /**
     * 兑吧曝光埋点
     * @param {IExposureData} exposure
     */
    NetManager.prototype.showLog = function (exposure) {
        var net = {
            name: 'showLog',
            uri: exposure.domain + '/exposure/standard',
            type: 'get',
            dataType: 'jsonp',
            param: exposure,
            callback: null,
            hideMsg: true
        };
        this.send(net);
    };
    /**
      * 消息响应
      * @param net
      * @param result 结果
      */
    NetManager.prototype.onResponse = function (net, result) {
        var _this = this;
        //数据处理
        var data = DataManager_1.DataManager.ins.updateData(net.name, result, net.param);
        if (net.pollingCheck) {
            console.log('result=====', result);
            console.log('data=====', data);
        }
        //接口成功
        if (net.pollingCount && net.pollingCheck(data)) {
            net.pollingCount -= 1;
            //轮询接口特殊处理
            setTimeout(function () {
                _this.send(net);
            }, 500);
        }
        else if (net.callback) {
            if (net.pollingCheck && !net.pollingCount && net.pollingCheck(data)) {
                net.callback('pollingFaild');
            }
            else {
                net.callback(data.success, data || result);
            }
        }
        if (!net.hideMsg) {
            GDispatcher_1.GDispatcher.dispatchEvent(ABNetManager_1.ABNetManager.ERROR, net, result.message || result.desc || result.msg);
        }
    };
    /**
     * 通讯底层错误
     * @param net
     * @param message
     */
    NetManager.prototype.onError = function (net) {
        if (net.callback) {
            net.callback(false);
        }
        if (!net.hideMsg) {
            GDispatcher_1.GDispatcher.dispatchEvent(ABNetManager_1.ABNetManager.ERROR, net);
        }
    };
    /**
     * 生成签名
     * @param {number} ticketId
     * @param {number} score
     * @param {any} gameData
     * @param {string} submitToken
     * @returns {string} 签名
     */
    NetManager.prototype.createSgin = function (ticketId, score, gameData, submitToken) {
        return window['duiba_md5'](ticketId + '' + score + '' + gameData + '' + submitToken);
    };
    //--------------------------------------------------新宿汰----------------------------------------------------
    /**
     * 获取domain
     */
    NetManager.prototype.getDomain = function (callback) {
        var net = {
            name: NetName_1.NetName.GET_DOMAIN,
            uri: '/projectx/getDomain.query',
            type: 'get',
            dataType: 'json',
            param: null,
            callback: callback
        };
        this.send(net);
    };
    /**
     * 用户数据稻穗树
     */
    NetManager.prototype.consumerData = function (callback) {
        var net = {
            name: NetName_1.NetName.CONSUMER_DATA,
            uri: window['CFG'].projectId + '/join_1/consumerData.do',
            type: 'get',
            dataType: 'json',
            param: null,
            callback: callback
        };
        this.send(net);
    };
    /**
     * 签到数据
     * @param callback
     */
    NetManager.prototype.getSignData = function (callback) {
        var net = {
            name: NetName_1.NetName.SIGN_DATA,
            uri: window['CFG'].projectId + '/join_1/data.do',
            type: 'get',
            dataType: 'json',
            param: null,
            callback: callback
        };
        this.send(net);
    };
    /**
     * 签到
     * @param callback
     */
    NetManager.prototype.sign = function (callback) {
        var net = {
            name: NetName_1.NetName.SIGN,
            uri: window['CFG'].projectId + '/join_1/join.do',
            type: 'post',
            dataType: 'json',
            param: null,
            callback: callback
        };
        this.send(net);
    };
    /**
     * 分享成功
     * @param callback
     */
    NetManager.prototype.shareData = function (callback) {
        var net = {
            name: NetName_1.NetName.SHARE,
            uri: window['CFG'].projectId + '/join_2/join.do',
            type: 'post',
            dataType: 'json',
            param: null,
            callback: callback
        };
        this.send(net);
    };
    /**
     * 获取任务状态数据
     */
    NetManager.prototype.getTaskData = function (callback) {
        var net = {
            name: NetName_1.NetName.GET_TASK_DATA,
            uri: window['CFG'].projectId + '/join_3/data.do',
            type: 'get',
            dataType: 'json',
            param: null,
            callback: callback
        };
        this.send(net);
    };
    /**
     * 获取商品数据
     */
    NetManager.prototype.getProjectData = function (callback) {
        var net = {
            name: NetName_1.NetName.GET_PROJECT_DATA,
            uri: window['CFG'].projectId + '/join_4/data.do',
            type: 'get',
            dataType: 'json',
            param: null,
            callback: callback
        };
        this.send(net);
    };
    /**
     * 领取任务奖励
     * @param callback
     */
    NetManager.prototype.getMoneyData = function (callback, taskCode) {
        var net = {
            name: NetName_1.NetName.GET_MONEY_DATA,
            uri: window['CFG'].projectId + '/join_3/join.do',
            type: 'post',
            dataType: 'json',
            param: {
                taskCode: taskCode
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 任务记录
     * @param callback
     */
    NetManager.prototype.taskFinish = function (callback) {
        var net = {
            name: NetName_1.NetName.TASK_FINISH,
            uri: '/projectx/p89bd3ef5' + '/join/taskFinish.do',
            type: 'post',
            dataType: 'json',
            param: {
                taskType: "SIGN"
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 兑换奖品奖励
     * @param callback
     */
    NetManager.prototype.exchangeProject = function (callback, prizeId) {
        var net = {
            name: NetName_1.NetName.EXCHANGE_PROJECT,
            uri: window['CFG'].projectId + '/join_4/join.do',
            type: 'post',
            dataType: 'json',
            param: {
                prizeId: prizeId
            },
            callback: callback
        };
        this.send(net);
    };
    return NetManager;
}(ABNetManager_1.ABNetManager));
exports.NetManager = NetManager;
__reflect(NetManager.prototype, "\"/Users/zuopeng/DBGitLab/db-game-template/egret/libs/tw/manager/NetManager\".NetManager");
//# sourceMappingURL=NetManager.js.map