"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var DoJoinPlugDrawData_1 = require("./../data/plug/doJoinPlugDraw/DoJoinPlugDrawData");
var NetName_1 = require("./../enum/NetName");
var TwLang_1 = require("../util/TwLang");
var GetPlugOrderStatusData_1 = require("../data/plug/doJoinPlugDraw/GetPlugOrderStatusData");
var GetRecordData_1 = require("../data/common/GetRecordData");
var ABDataManager_1 = require("../../tc/manager/ABDataManager");
/**
 *Created by cuiliqiang on 2018/3/8
 * 数据管理
 */
var DataManager = (function (_super) {
    __extends(DataManager, _super);
    function DataManager() {
        var _this = _super.call(this) || this;
        if (_this.isInit) {
            throw Error(TwLang_1.TwLang.lang_001);
        }
        _this.isInit = true;
        return _this;
    }
    Object.defineProperty(DataManager, "ins", {
        get: function () {
            if (!this.instance) {
                this.instance = new DataManager();
            }
            return this.instance;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * 更新数据
     * @param {NetName} name
     * @param result
     * @returns {any}
     */
    // tslint:disable-next-line:cyclomatic-complexity
    DataManager.prototype.updateData = function (name, result, param) {
        var data;
        switch (name) {
            case NetName_1.NetName.PLUG_DO_JOIN:
                if (!this._doJoinPlugDrawData) {
                    this._doJoinPlugDrawData = new DoJoinPlugDrawData_1.DoJoinPlugDrawData();
                }
                this._doJoinPlugDrawData.update(result);
                data = this._doJoinPlugDrawData;
                break;
            case NetName_1.NetName.PLUG_ORDER_STATUS:
                if (!this._getPlugOrderStatusData) {
                    this._getPlugOrderStatusData = new GetPlugOrderStatusData_1.GetPlugOrderStatusData();
                }
                this._getPlugOrderStatusData.update(result);
                data = this._getPlugOrderStatusData;
                break;
            case NetName_1.NetName.GET_RECORD://查询我的奖品记录
                if (!this._getRecordData) {
                    this._getRecordData = new GetRecordData_1.GetRecordData();
                }
                this._getRecordData.update(result);
                data = this._getRecordData;
            default:
                this[this.getKey(name)] = result;
        }
        return data || result;
    };
    DataManager.prototype.getData = function (name) {
        return this[this.getKey(name)];
    };
    DataManager.prototype.getKey = function (name) {
        return "_tw_data_" + name + "_";
    };
    Object.defineProperty(DataManager.prototype, "doJoinPlugDrawData", {
        /**
         * 插件
         */
        get: function () {
            return this._doJoinPlugDrawData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getPlugOrderStatusData", {
        /**
         * 插件订单结果
         */
        get: function () {
            return this._getPlugOrderStatusData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getRecordData", {
        /**
         * 查询我的奖品记录
         */
        get: function () {
            return this._getRecordData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getGameInfoData", {
        /**
         * 游戏主数据
         */
        get: function () {
            return this._gameInfoData;
        },
        set: function (d) {
            this._gameInfoData = d;
        },
        enumerable: true,
        configurable: true
    });
    return DataManager;
}(ABDataManager_1.ABDataManager));
exports.DataManager = DataManager;
__reflect(DataManager.prototype, "\"/Users/zuopeng/DBGitLab/db-game-template/egret/libs/tw/manager/DataManager\".DataManager");
//# sourceMappingURL=DataManager.js.map