import BaseItem from "../../physics/BaseItem";
import MovieClip from "../../physics/movieclip/MovieClip";
import LabelType from "./LabelType";

const createEgg = (scale) => {
    //气泡纹理种气泡的尺寸默认100（总体还包含气泡周围的阴影效果）
    const texture = RES.getRes('egg_json');
    const animation = createMovieClip(texture, 1);//礼物纹理大概130
    const baseItem = new BaseItem(animation, LabelType.egg);
    baseItem.scaleX = baseItem.scaleY = scale;
    return baseItem
}

const createMovieClip = (spritesheet, scale) => {
    const list = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];
    const movieclip = new MovieClip({
        spritesheet: spritesheet,
        frameInterval: 5,
        frames: list,
        position: [0, 0],
        scale: scale,
        anchor: [.5, .5]
    });
    return movieclip
}

export default createEgg