import getIsIOS from "../../new_tc/getIsIOS";
import wait from "../../new_tc/wait";
import { DataManager } from "../../tw/manager/DataManager";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import Scene from "./Scene";
import { TwFun } from "../../tw/util/TwFun";

export default class StartSceneBase extends Scene {
    ruleBtn: eui.Button;
    htmlRuleBtn: eui.Button;
    optionBtn: eui.Button;
    recordBtn: eui.Button;
    rankBtn: eui.Button;
    elements: eui.Group;
    slotsBtn: eui.Button;
    rotateBtn: eui.Button;
    exemptionTxt: eui.Label;

    async start(data?) {
        this.updateGetInfoView();
        this.updateExemptionTxt();
        super.start();
    }

    async playAnimation() {
        const btns = [this.ruleBtn, this.optionBtn, this.recordBtn, this.rankBtn];
        btns.forEach(btn => btn.alpha = 0)
        await wait(400);
        btns.forEach(btn => {
            egret.Tween.get(btn).to({ alpha: 1 }, 700, egret.Ease.backOut);
        });
    }

    private updateGetInfoView() {
        if (DataManager.ins.getInfoData) {
            this.updateStartBtnStatus();
            this.updateCountTxt();
        } else {
            DataManager.ins.once('dataUpdate', this.updateGetInfoView, this);
        }
    }

    async updateStartBtnStatus() {  }
    updateCountTxt() {  }

    updateExemptionTxt() {
        if (this.exemptionTxt) {
            if (getIsIOS()) {
                this.exemptionTxt.visible = true;
            } else {
                this.exemptionTxt.visible = false;
            }
        }
    }

    initEvents() {
        if (this.ruleBtn)
            this.ruleBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this);
        if (this.htmlRuleBtn)
            this.htmlRuleBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_htmlRuleBtn, this);
        if (this.optionBtn)
            this.optionBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_optionBtn, this);
        if (this.recordBtn)
            this.recordBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_recordBtn, this);
        if (this.rankBtn)
            this.rankBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_rankBtn, this);
        if (this.slotsBtn)
            this.slotsBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_slotsBtn, this);
        if (this.rotateBtn)
            this.rotateBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_rotateBtn, this);
    }
    
    onTap_rotateBtn(e: egret.Event) {
        PanelCtrl.instance.show(ModuleTypes.ROTATE_PANEL);
    }
    onTap_slotsBtn(e: egret.Event) {
        PanelCtrl.instance.show(ModuleTypes.SLOT_PANEL);
    }
    onTap_treasureBtn(e: egret.Event) {
        PanelCtrl.instance.show(ModuleTypes.TREASURE_PANEL);
    }
    onTap_ruleBtn(e: egret.Event) {
        PanelCtrl.instance.show(ModuleTypes.RULE_PANEL);
    }
    onTap_htmlRuleBtn(e: egret.Event) {
        PanelCtrl.instance.show(ModuleTypes.HTML_RULE_PANEL);
    }

    onTap_optionBtn(e: egret.Event) {
        PanelCtrl.instance.show(ModuleTypes.OPTIONS_PANEL);
    }

    onTap_recordBtn(e: egret.Event) {
        window.location.href = TwFun.getRecordUrl('00');
    }

    onTap_rankBtn(e: egret.Event) {
        PanelCtrl.instance.show(ModuleTypes.RANK_PANEL);
    }

    get skinKey() { return 'Start' }
}