import { NetManager } from './../../libs/tw/manager/NetManager';
import { Buried } from './../../libs/tw/util/Buried';
import ComponentBase from "../components/ComponentBase";

export default class Scene extends ComponentBase {
    constructor() {
        super()

        this.percentHeight = 100;
        this.percentWidth = 100;

    }

    start(data?) {
        this.initBuired()

    }

    initBuired() {

    }

    protected onSkinComplete() {
        super.onSkinComplete();
        egret.Tween.removeAllTweens();
        this.createLayers();
    }

    private _map: { [key: string]: egret.Sprite }
    createLayers() {
        this._map = {};
        for (const key of this.layerKeys) {
            const layer = new egret.Sprite();
            this.addChild(layer);
            this._map[key] = layer;
        }
    }

    initUI() {

    }

    getLayer(key) {
        return this._map[key]
    }

    protected get layerKeys() {
        return []
    }


}