import { ModuleTypes } from '../types/ModuleTypes';
import ComponentBase from "../components/ComponentBase";
import SceneCtrl from "../ctrls/sceneCtrl";

export default class Panel extends ComponentBase {
    constructor() {
        super();
        this.percentHeight = 100;
        this.percentWidth = 100;
    }

    initEvents() {
        this.closeBtns.forEach(
            btn => { if (btn) btn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this) }
        )
    }
    removeEvents() {
        this.closeBtns.forEach(
            btn => { if (btn) btn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this) }
        )
    }

    protected get closeBtns(): eui.Button[] { return [this['closeBtn']] }

    onTouchTap(): any {
        this.hidePanel();
    }

    hidePanel() {
        this.destroy();
        this.dispatchEvent(new egret.Event('onDestroy'));
    }

}