import { DataManager } from './../../libs/tw/manager/DataManager';
import NetConst from './../consts/NetConst';
import qcsNet from '../consts/qcsNet';
export class NetPromise {


    // 获取活动基础信息
    static getRemainTimes() {
        return new Promise((r, j) => {
            qcsNet.getRemainTimes((s) => {
                if (!s) {
                    j(s)
                    return
                }
                r()
            });
        })
    }

    static getRule() {
        return new Promise((r, j) => {
            qcsNet.getRule((s) => {
                if (!s) {
                    j(s)
                    return
                }
                r()
            });
        })
    }

    /**
     * 参与刮奖
     */
    static doJoin() {
        return new Promise((r, j) => {
            qcsNet.doJoin((s) => {
                if (!s) {
                    j(s)
                    return
                }
                r()
            });
        })
    }

    static getPrizeInfo() {
        return new Promise((r, j) => {
            qcsNet.getPrizeInfo((s) => {
                if (!s) {
                    j(s)
                    return
                }
                r()
            })
        })
    }

    /**
     * 查询用户中奖记录，一般用于展示中奖清单或轮播中奖
     * @param playwayId 玩法id数组
     */
    static queryAllUserRecords(playwayId) {
        return new Promise((r, j) => {
            qcsNet.queryAllUserRecords((s) => {
                if (!s) {
                    j(s)
                    return
                }
                r()
            }, playwayId)

        })
    }
}