import { GDispatcher } from './../../../libs/tc/util/GDispatcher';
import { NetPromise } from './../../promises/NetPromise';
import { DataManager } from './../../../libs/tw/manager/DataManager';
import { LotteryType } from './../../../libs/tw/enum/LotteryType';
import { NetManager } from './../../../libs/tw/manager/NetManager';
import { Buried } from './../../../libs/tw/util/Buried';
import Panel from "../../views/Panel";
import SceneCtrl from '../../ctrls/sceneCtrl';
import { ModuleTypes } from '../../types/ModuleTypes';
import ToastCtrl from '../../ctrls/toastCtrl';
import getOptionImgSize from './data/getOptionImgSize';
import ImgSizeType from './data/ImgSizeType';
import Waiting from '../../waiting/Waiting';

export default class PrizePanel extends Panel {

    protected get skinKey() { return 'Prize' }

    public prizeName: eui.Label;
    public sureBtn: eui.Button;
    public prizeImg: eui.Image;
    public closeBtn: eui.Button;
    public scoreTxt: eui.Label;
    public maxScoreTxt: eui.Label;



    get lottery() {
        let p;
        this.allPrize.forEach(prize => {
            if (prize.id == this.prize.prizeId) {
                p = prize
            }
        });
        return p
    }

    get prize() { return DataManager.ins.getData("doJoin") && DataManager.ins.getData("doJoin").data }
    get allPrize() { return DataManager.ins.getData("getPrizeInfo") && DataManager.ins.getData("getPrizeInfo").data }
    get picWidth() { return 250 };
    get picBigWidth() { return 500 };
    get bigPicRatio() { return 640 / 300 }

    //埋点

    // 开始
    start() {
        if (this.prize) {
            this.prizeImg.source = this.lottery.icon;
            this.prizeName.text = this.lottery.name + ""
        }

        this.initBuried()
    }

    getExposure
    initBuried() {
        let dpm = Buried.connectDpm(110, 1, 1)
        let dcm = Buried.connectDpm(202, 0, 0)
        this.getExposure = Buried.createExposure(dpm, dcm)
        NetManager.ins.showLog(this.getExposure)
    }


    initEvents() {
        super.initEvents();
        this.onTap(this.closeBtn, this.onTap_CloseBtn)
        this.onTap(this.sureBtn, this.onTap_GetPrize)
        this.onTap(this.prizeImg, this.onTap_GetPrize)
    }

    onTap_GetPrize() {
        NetManager.ins.clickLog(this.getExposure)

        setTimeout(() => {
            window.location.href = this.prize.url
        }, 200);

    }

    onTap_CloseBtn(e: egret.TouchEvent) {
        Waiting.instance.show()
        NetPromise.getRemainTimes()
            .then(() => {
                this.hidePanel()
                Waiting.instance.hide()
                SceneCtrl.instance.change(ModuleTypes.MAIN_SCENE)
            })
            .catch(e => {
                console.error(e);
                this.hidePanel()
                Waiting.instance.hide()
                SceneCtrl.instance.change(ModuleTypes.MAIN_SCENE)
                ToastCtrl.instance.show("网络错误，请稍后重试~")
            })
    }


    removeEvents() {
        super.removeEvents()
        this.clearTap(this.closeBtn, this.onTap_CloseBtn)
        this.clearTap(this.sureBtn, this.onTap_CloseBtn)
        this.clearTap(this.prizeImg, this.onTap_GetPrize)
    }

}