
import { DataManager } from './../../../libs/tw/manager/DataManager';
import { NetManager } from './../../../libs/tw/manager/NetManager';
import { ModuleTypes } from './../../types/ModuleTypes';
import Panel from "../../views/Panel";
import SceneCtrl from "../../ctrls/sceneCtrl";
import PanelCtrl from '../../ctrls/panelCtrl';
import { NetPromise } from '../../promises/NetPromise';
import ToastCtrl from '../../ctrls/toastCtrl';
import Waiting from '../../waiting/Waiting';
export default class NoPrizePanel extends Panel {
    protected get skinKey() { return 'NoPrize' }

    public bg: eui.Image;
    public againBtn: eui.Button;
    public closeBtn: eui.Button;
    public noPrizeTitle: eui.Image;
    public scoreTxt: eui.Label;
    public maxScoreTxt: eui.Label;



    start(data) {

    }

    initEvents() {
        super.initEvents();

        this.onTap(this.againBtn, this.onTap_CloseBtn)
        this.onTap(this.closeBtn, this.onTap_CloseBtn)
    }

    private onTap_CloseBtn(e: egret.TouchEvent) {
        Waiting.instance.show()
        NetPromise.getRemainTimes()
            .then(() => {
                this.hidePanel();
                Waiting.instance.hide()
                SceneCtrl.instance.change(ModuleTypes.MAIN_SCENE)
            })
            .catch((e) => {
                console.error(e);
                Waiting.instance.hide()
                ToastCtrl.instance.show("网络异常，请稍后再试~")
            })
    }

}