import { NetManager } from './../../libs/tw/manager/NetManager';
import { DataManager } from './../../libs/tw/manager/DataManager';
import { INetData } from './../../libs/tc/interface/INetData';
export default class qcsNet {

    /**
     * 获取剩余次数
     * @param callback 回调
     * @param projectxId 项目id
     */
    public static getRemainTimes(callback, projectxId = window["projectxId"]) {
        const net: INetData = {
            name: 'getRemainTimes',
            uri: `/projectx/${projectxId}/join_1/getRemainTime.do`,
            type: 'get',
            dataType: 'json',
            hideMsg: true,
            param: {},
            callback: callback
        };
        NetManager.ins.send(net);
    }

    public static getRule(callback, projectxId = window["projectxId"]) {
        const net: INetData = {
            name: 'getRule',
            uri: `/projectx/${projectxId}/projectRule.query`,
            type: 'get',
            dataType: 'json',
            hideMsg: true,
            param: {},
            callback: callback
        };
        NetManager.ins.send(net);
    }

    /**
     * 参与刮奖
     * @param callback 回调
     * @param projectxId 项目id
     */
    public static doJoin(callback, projectxId = window["projectxId"]) {
        const net: INetData = {
            name: 'doJoin',
            uri: `/projectx/${projectxId}/join_1/join.do`,
            type: 'get',
            dataType: 'json',
            hideMsg: true,
            param: {},
            callback: callback
        };
        NetManager.ins.send(net);
    }

    /**
     * 查询奖品信息
     * @param callback 回调
     * @param ids 奖品ID集合 英文逗号，隔开， 为空查询项目所有奖品
     * @param projectxId 
     */
    public static getPrizeInfo(callback, ids?, projectxId = window["projectxId"]) {
        let param: any = {}
        if (ids) {
            param.ids = ids
        }
        const net: INetData = {
            name: 'getPrizeInfo',
            uri: `/projectx/${projectxId}/prize.query`,
            type: 'get',
            dataType: 'json',
            hideMsg: true,
            param: param,
            callback: callback
        };
        NetManager.ins.send(net);
    }

    /**
     * 查询用户中奖记录，一般用于展示中奖清单或轮播中奖
     * @param callback 回调
     * @param playwayId 玩法id数组
     * @param projectxId 项目id
     */
    public static queryAllUserRecords(callback: Function, playwayId, projectxId = window['projectxId']): void {
        const param: any = {
            playwayId: playwayId
        };

        const net: INetData = {
            name: 'queryAllUserRecords',
            uri: `/projectx/${projectxId}/queryAllUserRecords`,
            type: 'post',
            dataType: 'json',
            param: param,
            hideMsg: true,
            callback: callback
        };
        NetManager.ins.getToken(net);
    }
}