import { NetPromise } from './../../promises/NetPromise';
import { NetManager } from '../../../libs/tw/manager/NetManager';
import { DataManager } from '../../../libs/tw/manager/DataManager';
import { HtmlTextParser } from "./HtmlTextParser";
import Panel from "../../views/Panel";
import ToastCtrl from '../../ctrls/toastCtrl';

export default class RulePanel extends Panel {
    public labContent: eui.Label;
    public scroller: eui.Scroller;
    start() {
        if (window['ruleTxt']) {
            this.labContent.textFlow = (new HtmlTextParser).parser(window['ruleTxt']);
        } else {
            if (!DataManager.ins.getData("getRule")) {
                NetPromise.getRule()
                    .then(() => {
                        this.addRule();
                    })
                    .catch((e) => {
                        console.error(e);
                        ToastCtrl.instance.show("获取规则失败，请稍后重试~")
                    })
            }
            else {
                this.addRule();
            }
        }
    }

    group: eui.Group;
    private addRule() {
        const text = DataManager.ins.getData("getRule").data;
        this.labContent.textFlow = (new HtmlTextParser).parser(text);
    }

    get skinKey() { return 'Rule' }
}