import { ModuleTypes } from '../../types/ModuleTypes';
import { NetManager } from "../../../libs/tw/manager/NetManager";
import Panel from "../../views/Panel";
import SceneCtrl from '../../ctrls/sceneCtrl';
export default class Msg extends Panel {


    set message(val) {

    }
    set btnTxt(val) {

    }

    public bg: eui.Image;
    public closeBtn: eui.Button;
    public sureBtn: eui.Button;
    public msgTitle: eui.Label;
    public msgTxt: eui.Label;


    start(data?) {
        this.data.message = data ? (data.msg ? data.msg : '网络异常，请稍后再试~') : '网络异常，请稍后再试~';
        this.data.type = data ? (data.type ? data.type : 'err') : 'err';
        this.data.title = data ? (data.title ? data.title : null) : null;
        this['msgTxt'].text = `${this.data.message}`;
        if (this.data.title) {
            if (this['msgTitle']) {
                this['msgTitle'].text = `${this.data.title}`;
            }
        }
    }

    protected get creditsOutBtns(): eui.Button[] {
        return [this['creditsOutBtn']]
    }

    protected get closeBtns(): eui.Button[] {
        return [this['closeBtn']]
    }

    initEvents() {
        this.onTap(this.sureBtn, this.onTap_closeBtn)
        this.onTap(this.closeBtn, this.onTap_closeBtn)
    }

    private onTap_closeBtn(e: egret.TouchEvent) {
        this.hidePanel();
        switch (this.data.type) {
            case 'reload':
                window.location.reload();
                break;
            case 'tips':

                break;
            case 'err':
                SceneCtrl.instance.change(ModuleTypes.START_SCENE);
                break;
            case 'creditsOut':
                if (window['CFG'].appInfo && window['CFG'].appInfo.earnCreditsUrl) {
                    window.location.href = window['CFG'].appInfo.earnCreditsUrl;
                } else {
                    SceneCtrl.instance.change(ModuleTypes.START_SCENE);
                }
                break;
            case 'requirelogin':
                if (window['requirelogin']) {
                    window['requirelogin']();
                } else {
                    SceneCtrl.instance.change(ModuleTypes.START_SCENE);
                }
                break;
            default:
                SceneCtrl.instance.change(ModuleTypes.START_SCENE);
                break;
        }
    }

    removeEvents() {
        this.clearTap(this.closeBtn, this.onTap_closeBtn)
        this.clearTap(this.sureBtn, this.onTap_closeBtn)
    }

    protected get skinKey() { return 'Msg' }
}