import { TwFun } from './../../libs/tw/util/TwFun';
import { NetManager } from './../../libs/tw/manager/NetManager';
import { ModuleTypes } from './../types/sceneTypes';
import { DataManager } from './../../libs/tw/manager/DataManager';
import Scene from "../views/Scene";
import PanelCtrl from '../ctrls/panelCtrl';
import NetConst from '../NetConst';
import SceneCtrl from '../ctrls/sceneCtrl';
import ToastCtrl from '../ctrls/toastCtrl';
import Waiting from '../waiting/Waiting';
import GameConst from '../GameConst';
export default class StartScene extends Scene {
    public bg: eui.Image;
    public ruleBtn: eui.Button;
    public recordBtn: eui.Button;
    public startBtn: eui.Button;
    public costTxt: eui.Label;
    public ele0: eui.Image;
    public ele4: eui.Image;
    public ele3: eui.Image;
    public ele2: eui.Image;
    public ele1: eui.Image;
    public ele5: eui.Image;
    public ele6: eui.Image;
    public man: eui.Group;
    public eye1: eui.Image;
    public eye0: eui.Image;
    public musicBtn: eui.Button;



    protected get skinKey() { return 'Start' }


    onSkinComplete() {
        super.onSkinComplete();
        this.initBuired();
        this.initUI();
        this.initAni();
    }

    initBuired() {

    }


    initUI() {

        this.updateData();

        if (GameConst.isPlayMusic) {
            // playBg();
            window['playMusic']("bgMusic", true);
            this['musicOn'].visible = true;
            this['musicOff'].visible = false;
        } else {
            window['playMusic']("bgMusic", false);
            this['musicOn'].visible = false;
            this['musicOff'].visible = true;
        }
    }

    initAni() {

        egret.Tween.get(this.startBtn)
            .wait(2000)
            .call(() => {
                egret.Tween.get(this.startBtn, { loop: true })
                    .to({ scaleX: 0.9, scaleY: 1.1 }, 170)
                    .to({ scaleX: 1, scaleY: 1 }, 160)
                    .to({ scaleX: 0.95, scaleY: 1.05 }, 170)
                    .to({ scaleX: 1, scaleY: 1 }, 170)
                    .wait(500)
            })

        egret.Tween.get(this.man, { loop: true })
            .wait(330)
            .to({ scaleY: 0.995, scaleX: 1.005 }, 670)
            .to({ scaleX: 1, scaleY: 1 }, 670)

        //0.33s(100%,100%)-0.43s(100%,0%)-0.53s(100%,100%);循环动画；相隔时间：2.47s
        egret.Tween.get(this.eye0, { loop: true })
            .wait(330)
            .to({ scaleY: 0 }, 100)
            .to({ scaleY: 1 }, 100)
            .wait(2470)
        egret.Tween.get(this.eye1, { loop: true })
            .wait(330)
            .to({ scaleY: 0 }, 100)
            .to({ scaleY: 1 }, 100)
            .wait(2470)

        egret.Tween.get(this.ele0, { loop: true })
            .wait(330)
            .to({ x: 40, y: 268 }, 1670)
            .to({ x: 46, y: 274 }, 1670)

        egret.Tween.get(this.ele4, { loop: true })
            .wait(330)
            .to({ x: 98.5 - 6 }, 1670)
            .to({ x: 98.5 }, 1670)

        egret.Tween.get(this.ele2, { loop: true })
            .wait(330)
            .to({ x: 493 + 6 }, 1670)
            .to({ x: 493 }, 1670)

        egret.Tween.get(this.ele1, { loop: true })
            .wait(330)
            .to({ x: 633 + 6, y: 325 - 6 }, 1670)
            .to({ x: 633, y: 325 }, 1670)

        egret.Tween.get(this.ele3, { loop: true })
            .wait(330)
            .to({ x: 9.5 - 6, y: 593 + 6 }, 1670)
            .to({ x: 9.5, y: 593 }, 1670)

        egret.Tween.get(this.ele5, { loop: true })
            .wait(330)
            .to({ x: 637 + 6, y: 582 + 6 }, 1670)
            .to({ x: 637, y: 582 }, 1670)

        egret.Tween.get(this.ele6)
            .wait(1000)
            .to({ scaleX: 1.2, scaleY: 1.2 }, 230)
            .to({ scaleX: 1, scaleY: 1 }, 100)

    }

    updateData() {

        if (DataManager.ins.customCfgData["uid"] == 'not_login') {
            // 未登录
            this.costTxt.text = `未登录`
            return
        }
        if (DataManager.ins.getData('gameAjaxElement').data && DataManager.ins.getData('gameAjaxElement').data.element) {
            if (DataManager.ins.getData('gameAjaxElement').data.element.status == 3) {
                this.costTxt.text = `游戏次数已用完`;
            } else if (DataManager.ins.getData('gameAjaxElement').data.element.status == 4) {
                this.costTxt.text = `今日次数已用完`;
            } else if (DataManager.ins.getData('gameAjaxElement').data.element.status == 5 && DataManager.ins.getData('gameAjaxElement').data.element.freeLimit > 0) {
                this.costTxt.text = `今日剩余免费次数:${DataManager.ins.getData('gameAjaxElement').data.element.freeLimit}次`
            } else if (DataManager.ins.getData('gameAjaxElement').data.element.status == 7 && DataManager.ins.getData('gameAjaxElement').data.element.freeLimit > 0) {
                this.costTxt.text = `剩余免费次数:${DataManager.ins.getData('gameAjaxElement').data.element.freeLimit}次`
            } else if (DataManager.ins.getData('gameAjaxElement').data.element.status == 2 || DataManager.ins.getData('gameAjaxElement').data.element.needCreditsLong > DataManager.ins.getData('gameAjaxElement').data.element.myCreditsLong) {
                this.costTxt.text = `${DataManager.ins.customCfgData.unitName || '积分'}不足`;
            } else {
                this.costTxt.text = `${DataManager.ins.getData('gameAjaxElement').data.element.needCredits}${DataManager.ins.customCfgData.unitName || '积分'}/次`
            }
        }
    }

    initEvents() {
        super.initEvents();
        this.onTap(this.startBtn, this.onTap_startBtn);
        this.onTap(this.ruleBtn, this.onTap_ruleBtn);
        this.onTap(this.recordBtn, this.onTap_recordBtn);

        this.onTap(this['musicOn'], this.onTap_musicOn);
        this.onTap(this['musicOff'], this.onTap_musicOff);

        this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
    }

    onEnterFrame() {
        this['musicOn'].rotation += 0.5
    }

    onTap_startBtn(e): void {

        if (DataManager.ins.customCfgData["uid"] == 'not_login') {
            // 未登录
            PanelCtrl.instance.show(ModuleTypes.LOGIN_PANEL);
            return
        }
        if (DataManager.ins.getData('gameAjaxElement').data && DataManager.ins.getData('gameAjaxElement').data.element) {
            if (DataManager.ins.getData('gameAjaxElement').data.element.status == 3) {
                ToastCtrl.instance.show(`游戏次数已用完`);
            } else if (DataManager.ins.getData('gameAjaxElement').data.element.status == 4) {
                ToastCtrl.instance.show(`今日次数已用完，请明日再来吧~`);
            } else if (DataManager.ins.getData('gameAjaxElement').data.element.status == 5 && DataManager.ins.getData('gameAjaxElement').data.element.freeLimit > 0) {
                this.doStart();
            } else if (DataManager.ins.getData('gameAjaxElement').data.element.status == 2 || DataManager.ins.getData('gameAjaxElement').data.element.needCreditsLong > DataManager.ins.getData('gameAjaxElement').data.element.myCreditsLong) {
                PanelCtrl.instance.show(ModuleTypes.GETCREDITS_PANEL);
            } else {
                this.doStart();

            }
        }
    }

    doStart() {
        Waiting.instance.show();
        NetConst.doJoin((s) => {
            if (!s) {
                // this.enableMouseEvt(true);
                Waiting.instance.hide();
                // let data = { msg: `${DataManager.ins.getData("doJoin").desc || "网络异常，请稍后再试~"}`, type: "tips" }
                // PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, data)
                ToastCtrl.instance.show(`活动太火爆了，请稍后再来~`);
                return
            }
            NetConst.getNgameStartStatus((ss) => {
                Waiting.instance.hide();
                if (!ss) {
                    ToastCtrl.instance.show(`活动太火爆了，请稍后再来~`);
                    return
                }
                SceneCtrl.instance.change(ModuleTypes.PLAY_SCENE);
            }, DataManager.ins.getData("doJoin").data, () => {
                return DataManager.ins.getData('getNgameStartStatus').code == 'C000000001'
            })
        })
    }

    onTap_ruleBtn() {
        PanelCtrl.instance.show(ModuleTypes.RULE_PANEL);
    }

    onTap_recordBtn() {
        window.location.href = TwFun.getRecordUrl("00");
    }

    onTap_musicOn(e) {
        e.stopPropagation();
        GameConst.isPlayMusic = false;
        this['musicOn'].visible = !this['musicOn'].visible;
        this['musicOff'].visible = !this['musicOff'].visible;

        window["playMusic"]("bgMusic", false);
    }

    onTap_musicOff(e) {
        e.stopPropagation();
        GameConst.isPlayMusic = true;
        this['musicOn'].visible = !this['musicOn'].visible;
        this['musicOff'].visible = !this['musicOff'].visible;

        window["playMusic"]("bgMusic", true);
    }

    removeEvents() {
        super.removeEvents();
        this.clearTap(this.startBtn, this.onTap_startBtn);
        this.clearTap(this.ruleBtn, this.onTap_ruleBtn);
        this.clearTap(this.recordBtn, this.onTap_recordBtn);

        this.clearTap(this['musicOn'], this.onTap_musicOn);
        this.clearTap(this['musicOn'], this.onTap_musicOff);

        this.removeEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
    }
}