import { NetManager } from './../../libs/tw/manager/NetManager';
import { DataManager } from './../../libs/tw/manager/DataManager';
import { HtmlTextParser } from "./HtmlTextParser";
import Panel from "../views/Panel";
import NetConst from '../NetConst';

export default class RulePanel extends Panel {
    public labContent: eui.Label;
    public scroller: eui.Scroller;
    start() {
        if (window['ruleTxt']) {
            this.labContent.textFlow = (new HtmlTextParser).parser(window['ruleTxt']);
            this.labContent.textColor = 0x000000;
        } else {
            if (!DataManager.ins.getData("gameAjaxElement").data || !DataManager.ins.getData("gameAjaxElement").data.rule) {
                NetConst.ajaxElement(() => {
                    // DataManager
                    this.addRule();
                });
            }
            else {
                this.addRule();
            }
        }
    }

    group: eui.Group;
    private addRule() {
        const text = DataManager.ins.getData("gameAjaxElement").data.rule;
        this.labContent.textFlow = (new HtmlTextParser).parser(text);
        this.labContent.textColor = 0x000000;
    }

    get skinKey() { return 'Rule' }
}