import { Buried } from '../../libs/tw/util/Buried';
import { LotteryType } from '../../libs/tw/enum/LotteryType';
import { DataManager } from '../../libs/tw/manager/DataManager';
import { NetManager } from '../../libs/tw/manager/NetManager';
import { ModuleTypes } from '../types/sceneTypes';
import Panel from "../views/Panel";
import SceneCtrl from '../ctrls/sceneCtrl';
import NetConst from '../NetConst';
import PanelCtrl from '../ctrls/panelCtrl';
import GameConst from '../GameConst';
import Waiting from '../waiting/Waiting';
import ImgSizeType from './data/ImgSizeType';
import getOptionImgSize from './data/getOptionImgSize';

export default class PrizePanel extends Panel {
    protected get skinKey() { return 'Prize' }

    public light: eui.Image;
    public bg: eui.Image;
    public img: eui.Image;
    public closeBtn: eui.Button;
    public prizeName: eui.Label;
    public againBtn: eui.Button;
    public prizeTitle: eui.Image;
    public prizeTips: eui.Label;



    private score: number;
    private useExposure: any;

    get lottery() { return DataManager.ins.getData("getOrderStatus").data.lottery; }
    get picWidth() { return 250 };
    get picBigWidth() { return 500 };
    get bigPicRatio() { return 640 / 300 }

    constructor(data) {
        super();
        this.score = data;

        this.initBuired();
        this.initUI();
        this.initAni();
    }

    initBuired() {

    }

    initUI() {

        if (this.lottery) {
            const sizeType = getOptionImgSize(this.lottery);
            if (ImgSizeType.BIG === sizeType) {

                this.img.width = this.picBigWidth;
                this.img.height = this.picBigWidth / this.bigPicRatio;
            } else {
                this.img.width = this.img.height = this.picWidth;
            }
            this.prizeName.text = this.lottery.title;
            this.img.source = this.lottery.imgUrl;
            this.img.y = 522;
            this.img.anchorOffsetX = 250 / 2;
            this.img.anchorOffsetY = 250 / 2;
        }
    }

    initAni() {
        egret.Tween.get(this.light, { loop: true })
            .to({ rotation: 360 }, 5000)
    }


    initEvents() {
        this.img.once(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
        this.onTap(this.closeBtn, this.onTap_closeBtn);
        this.onTap(this.againBtn, this.onTap_closeBtn);
    }

    onTap_closeBtn(e) {
        Waiting.instance.show();
        NetConst.ajaxElement((s) => {
            Waiting.instance.hide();
            this.hidePanel();
            SceneCtrl.instance.change(ModuleTypes.START_SCENE);
        })
    }

    onUse() {
        if (this.lottery.type == LotteryType.LUCKY) {
            window["downloadAppConfig"] =
                {
                    openUrl: this.lottery.openUrl,
                    iosDownloadUrl: this.lottery.iosDownloadUrl,
                    androidDownloadUrl: this.lottery.androidDownloadUrl,
                    confirm: this.lottery.confirm ? this.lottery.confirm : false
                };
            window["downloadApp"]();
            if (this.lottery.type == "lucky") {
                NetManager.ins.spmclick(DataManager.ins.getData("getOrderStatus").exposure);
            }
        } else {
            window.location.href = DataManager.ins.getData("getOrderStatus").data.lottery.link;
        }

    }

    removeEvents() {
        // this.clearTap(this.acceptBtn, this.onUse);
        this.clearTap(this.againBtn, this.onTap_closeBtn);
        this.clearTap(this.closeBtn, this.onTap_closeBtn);
    }
}