import { DataManager } from './../../libs/tw/manager/DataManager';
import { GarbageTypes } from './../playScene/GarbageTypes';
import { ModuleTypes } from './../types/sceneTypes';
import Scene from "../views/Scene";
import Waiting from "../waiting/Waiting";
import NetConst from '../NetConst';
import SceneCtrl from '../ctrls/sceneCtrl';
import GarbageConfig from '../playScene/GarbageConfig';
import submit from '../../libs/new_tw/ctrls/submit';
import NetModel from '../NetModel';
import PanelCtrl from '../ctrls/panelCtrl';
import GameConst from '../GameConst';
export default class OverScene extends Scene {
    get skinKey() { return "Over" }

    public bg: eui.Image;
    public scoreTxt: eui.Label;
    public title: eui.Label;
    public minTitle: eui.Label;
    public wrongEmoji: eui.Image;
    public anwserList: eui.Scroller;
    public anwerGroup: eui.Group;
    public drawBtn: eui.Button;
    public againBtn: eui.Button;
    public musicOn: eui.Image;
    public musicOff: eui.Image;

    private _score: number = 0;
    private config: any[];
    private anwserPool: any[] = [];
    private wrongPool: any[] = [];
    private mistakePool: any[] = [];
    private dirRightPool: any[] = [];
    constructor(data) {
        super()
        Waiting.instance.hide();
        this._score = data.score;
        this.anwserPool = data.anwserPool;
        this.config = GarbageConfig.config;

        if (GameConst.isPlayMusic) {
            // playBg();
            window['playMusic']("bgMusic", true);
            this['musicOn'].visible = true;
            this['musicOff'].visible = false;
        } else {
            window['playMusic']("bgMusic", false);
            this['musicOn'].visible = false;
            this['musicOff'].visible = true;
        }


        this.updateScore();
        this.updateTitle();
        this.updateMinTitle();
        this.updateAnwserList();
    }


    updateScore() {
        let data = { score: 0 };
        egret.Tween.get(
            data,
            {
                onChange: () => {
                    this.scoreTxt.text = data.score.toFixed(0) + "";
                }
            }
        )
            .to({ score: this._score }, 1000)


    }

    updateTitle() {
        if (this._score >= 0 && this._score <= 30) {
            this.title.text = `环保萌新`;
        } else if (this._score >= 31 && this._score <= 50) {
            this.title.text = `环保初学者`;
        } else if (this._score >= 51 && this._score <= 80) {
            this.title.text = `环保践行者`;
        } else if (this._score >= 81 && this._score <= 100) {
            this.title.text = `环保先进个人`
        }

    }

    updateMinTitle() {

        let num = 0;
        this.anwserPool.forEach((garbage) => {
            if (garbage.isRight == true) {
                num++;
            }
        })
        this.minTitle.text = `恭喜您在垃圾分类的学习中分对了${num}种垃圾，\n下方标红处有过出错记录，快去看看加强记忆吧。`
        if (num == 0) {
            this.wrongEmoji.visible = true;
        }
    }

    updateAnwserList() {
        let i = 0;
        this.anwserPool.forEach((garbage, idx) => {
            let type = null;
            if (garbage.isRight && garbage.isMistake) {
                switch (garbage.type) {
                    case GarbageTypes.recoverableWaste:
                        type = "可回收垃圾"
                        break;
                    case GarbageTypes.harmfulWaste:
                        type = "有害垃圾"
                        break;
                    case GarbageTypes.wetWaste:
                        type = "湿垃圾"
                        break;
                    case GarbageTypes.dryWaste:
                        type = "干垃圾"
                        break;
                }
                let tips = new eui.Label();
                tips.text = garbage.name + "——" + type;
                tips.textColor = 0xff0000;
                tips.y = 20 + i * 50;
                tips.horizontalCenter = 0;
                this.anwerGroup.addChild(tips);

                i++;
            }
        });

        this.anwserPool.forEach((garbage, idx) => {
            let type = null;
            if (garbage.isRight && !garbage.isMistake) {
                switch (garbage.type) {
                    case GarbageTypes.recoverableWaste:
                        type = "可回收垃圾"
                        break;
                    case GarbageTypes.harmfulWaste:
                        type = "有害垃圾"
                        break;
                    case GarbageTypes.wetWaste:
                        type = "湿垃圾"
                        break;
                    case GarbageTypes.dryWaste:
                        type = "干垃圾"
                        break;
                }
                let tips = new eui.Label();
                tips.text = garbage.name + "——" + type;
                tips.textColor = 0x000000;
                tips.y = 20 + i * 50;
                tips.horizontalCenter = 0;
                this.anwerGroup.addChild(tips);

                i++;
            }
        });
    }

    initEvents() {
        super.initEvents();
        this.onTap(this.againBtn, this.onTap_againBtn)
        this.onTap(this.drawBtn, this.onTap_drawBtn)


        this.onTap(this['musicOn'], this.onTap_musicOn);
        this.onTap(this['musicOff'], this.onTap_musicOff);

        this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
    }

    onEnterFrame() {
        this['musicOn'].rotation += 0.5;
    }

    onTap_musicOn(e) {
        e.stopPropagation();
        GameConst.isPlayMusic = false;
        this['musicOn'].visible = !this['musicOn'].visible;
        this['musicOff'].visible = !this['musicOff'].visible;

        window["playMusic"]("bgMusic", false);
    }

    onTap_musicOff(e) {
        e.stopPropagation();
        GameConst.isPlayMusic = true;
        this['musicOn'].visible = !this['musicOn'].visible;
        this['musicOff'].visible = !this['musicOff'].visible;

        window["playMusic"]("bgMusic", true);
    }

    onTap_againBtn() {
        NetConst.ajaxElement(() => {
            SceneCtrl.instance.change(ModuleTypes.START_SCENE)
        })
    }

    async onTap_drawBtn() {
        // this.drawBtn.touchEnabled = false;
        Waiting.instance.show();
        NetConst.ngameSubmit(
            (s) => {
                if (!s) {
                    Waiting.instance.hide();
                    PanelCtrl.instance.show(ModuleTypes.NOPRIZE_PANEL);
                    return
                }
                NetConst.getOrderStatus(
                    (ss) => {
                        Waiting.instance.hide();
                        if (!ss) {
                            PanelCtrl.instance.show(ModuleTypes.NOPRIZE_PANEL);
                            return
                        }
                        if (DataManager.ins.getData("getOrderStatus") && DataManager.ins.getData("getOrderStatus").data && DataManager.ins.getData("getOrderStatus").data.lottery && DataManager.ins.getData("getOrderStatus").data.lottery.type !== "thanks") {
                            PanelCtrl.instance.show(ModuleTypes.PRIZE_PANEL)
                        } else {
                            PanelCtrl.instance.show(ModuleTypes.NOPRIZE_PANEL);
                        }
                    },
                    DataManager.ins.getData("doJoin").data,
                    () => {
                        return DataManager.ins.getData("getOrderStatus").code == "C000000001";
                    },
                    10
                )
            },
            DataManager.ins.getData("doJoin").data,
            this._score,
            [],
            [],
            DataManager.ins.getData("getNgameStartStatus").data.submitToken,
            window['rankId']
        )
        // let data: any = await NetModel.submit(DataManager.ins.getData("doJoin").data, this._score)
        // this.log(data)
        // if (data && data.success) {
        //     // 出未中奖弹窗
        //     if (DataManager.ins.getData("getOrderStatus") && DataManager.ins.getData("getOrderStatus").data && DataManager.ins.getData("getOrderStatus").data.lottery && DataManager.ins.getData("getOrderStatus").data.lottery.type !== "thanks") {
        //         PanelCtrl.instance.show(ModuleTypes.PRIZE_PANEL)
        //     } else {
        //         PanelCtrl.instance.show(ModuleTypes.NOPRIZE_PANEL);
        //     }
        // } else {
        //     PanelCtrl.instance.show(ModuleTypes.NOPRIZE_PANEL);
        // }
    }

    removeEvents() {
        super.removeEvents();
        this.clearTap(this.againBtn, this.onTap_againBtn);
        this.clearTap(this.drawBtn, this.onTap_drawBtn);

        this.clearTap(this['musicOn'], this.onTap_musicOn);
        this.clearTap(this['musicOn'], this.onTap_musicOff);

        this.removeEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
    }
}