import Panel from "../views/Panel";

export default class LoginPanel extends Panel {

    get skinKey() { return "Login" }

    public bg: eui.Image;
    public loginBtn: eui.Button;


    initEvents() {
        super.initEvents();
        this.onTap(this.loginBtn, this.onTap_loginBtn);

    }

    onTap_loginBtn() {

        if (window['requirelogin']) {
            window['requirelogin']();
            this.hidePanel();
        } else {
            this.hidePanel();
        }
    }

    removeEvents() {
        super.removeEvents();
        this.clearTap(this.loginBtn, this.onTap_loginBtn);
    }
}