import { DataManager } from './../../libs/tw/manager/DataManager';
import Panel from "../views/Panel";

export default class GetCreditsPanel extends Panel {

    get skinKey() { return "GetCredits" }

    public bg: eui.Image;
    public earnBtn: eui.Group;
    public btnTxt: eui.Label;
    public closeBtn: eui.Button;
    public tips: eui.Label;


    constructor() {
        super()
        this.btnTxt.text = `赚${DataManager.ins.customCfgData.unitName}`;
        this.tips.text = `抱歉，您当前的${DataManager.ins.customCfgData.unitName}不足`;
    }

    initEvents() {
        super.initEvents();
        this.onTap(this.earnBtn, this.onTap_earnBtn);
    }

    onTap_earnBtn() {

        // 赚积分链接
        if (window["CFG"] && window["CFG"].getCreditsLink && window["CFG"].getCreditsLink !== "") {
            window.location.href = window["CFG"].getCreditsLink;
        } else {
            this.hidePanel();
        }
    }

    removeEvents() {
        super.removeEvents();
        this.clearTap(this.earnBtn, this.onTap_earnBtn);
    }

}