
import { Buried } from './../libs/tw/util/Buried';
import { GDispatcher } from './../libs/tc/util/GDispatcher';
import { DataManager } from './../libs/tw/manager/DataManager';
import { ABNetManager } from './../libs/tc/manager/ABNetManager';
import { INetData } from './../libs/tc/interface/INetData';
import MainBase from "../libs/tl/MainBase";
import { NetManager } from "../libs/tw/manager/NetManager";
import Alert from "./alert/Alert";
import PanelCtrl from "./ctrls/panelCtrl";
import SceneCtrl from "./ctrls/sceneCtrl";
import { ModuleTypes } from "./types/sceneTypes";
import RulePanel from './rulePanel/RulePanel';
import Msg from "./alert/Msg";
import GameConst, { wait } from './GameConst';
import Waiting from './waiting/Waiting';
import NetConst from './NetConst';
import NoPrizePanel from './prize/NoPrizePanel';
import PrizePanel from './prize/PrizePanel';
import StartScene from './startScene/StartScene';
import PlayScene from './playScene/PlayScene';
import OverScene from './overScene/OverScene';
import ToastCtrl from './ctrls/toastCtrl';
// import SVGACtrl from './ctrls/svgaCtrl';
import LoginPanel from './login/LoginPanel';
import GetCreditsPanel from './getCredits/GetCreditsPanel';

class Main extends MainBase {

    protected registerModules() {

        // 注册Toast
        ToastCtrl.instance.registerClass();
        // 注册所有Panel
        PanelCtrl.instance.registerClass(ModuleTypes.LOGIN_PANEL, LoginPanel);
        PanelCtrl.instance.registerClass(ModuleTypes.GETCREDITS_PANEL, GetCreditsPanel)
        PanelCtrl.instance.registerClass(ModuleTypes.MSG_PANEL, Msg);
        PanelCtrl.instance.registerClass(ModuleTypes.RULE_PANEL, RulePanel);
        PanelCtrl.instance.registerClass(ModuleTypes.PRIZE_PANEL, PrizePanel);
        PanelCtrl.instance.registerClass(ModuleTypes.NOPRIZE_PANEL, NoPrizePanel);
        // // 注册所有Scene
        SceneCtrl.instance.registerClass(ModuleTypes.START_SCENE, StartScene);
        SceneCtrl.instance.registerClass(ModuleTypes.PLAY_SCENE, PlayScene);
        SceneCtrl.instance.registerClass(ModuleTypes.OVER_SCENE, OverScene);

        // NetManager.ins.onNotSuccess = (msg) => {
        //     showAlertPanel(msg)
        // }
    }

    // 获取数据
    public updateCount: number = 0;
    protected async getData() {
        super.getData()
        //加载svga
        // let mv = await SVGACtrl.instance.load("http://yun.duiba.com.cn/db_games/activity/garbageSorting1.00/guideTips.svga");
        // let soundArr = ["numCountDown_mp3", "rightTips_mp3"]
        // preloadSound(soundArr);
        if (!GameConst.getQueryString("first")) {
            if (window.location.href.indexOf("?") >= 0) {
                window.location.href = window.location.href + "&first=1"
            } else {
                window.location.href = window.location.href + "?first=1"
            }

        }
    }



    // 设置派发事件
    protected GDispatchEvent() {
        GDispatcher.addEvent(ABNetManager.ERROR, (net: INetData, msg = '') => {
            const msgData = {
                net: net,
                msg: msg,
                // sureBtnTxt: TlLang.lang_011
            };
            PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, msgData)
        }, this);
        // 监听当预加载资源加载完毕
        GDispatcher.addEvent('PreloadLoaded', () => {
            Waiting.instance.show()
            // this.createGameScene()
        }, this);
        GDispatcher.addEvent('DelayLoaded', () => {

            Waiting.instance.hide()
            this.createGameScene()
        }, this);
    }

    protected onResourceLoadComplete(event: RES.ResourceEvent): void {
        if (event.groupName == "Preload") {
            this.trace("preload组加载完成");
            this.trace("开始加载Normal资源");
            // this.loadBg("startBg.png");
            GDispatcher.dispatchEvent('PreloadLoaded');
            window['isPreloadLoaded'] = true;
            RES.loadGroup("Normal");
        } else if (event.groupName == "Normal") {
            this.trace("Normal组加载完成");
            this.trace("开始加载Garbage资源");
            GDispatcher.dispatchEvent('NormalLoaded');
            RES.loadGroup("Garbage");
        } else if (event.groupName == "Garbage") {
            this.trace("Garbage组加载完成");
            this.trace("开始加载Delay资源");
            GDispatcher.dispatchEvent('GarbageLoaded');
            RES.loadGroup("Delay");
        } else if (event.groupName == "Delay") {
            this.trace("Delay组加载完成");
            GDispatcher.dispatchEvent('DelayLoaded');
            RES.removeEventListener(RES.ResourceEvent.GROUP_COMPLETE, this.onResourceLoadComplete, this);
            RES.removeEventListener(RES.ResourceEvent.GROUP_LOAD_ERROR, this.onResourceLoadError, this);
            RES.removeEventListener(RES.ResourceEvent.GROUP_PROGRESS, this.onResourceProgress, this);
        }
    }

    // 创建游戏场景
    protected createGameScene() {
        super.createGameScene();
        //获取UA信息
        let userAgent = navigator.userAgent.toLowerCase();
        console.log(userAgent);
        GameConst.stage = this.stage;
        setTimeout(() => {
            console.log(GameConst.stage.width, GameConst.stage.height)
        }, 100);

        Buried.init();
        // 端内发接口
        NetConst.ajaxElement((s) => {
            if (s) {
                SceneCtrl.instance.change(ModuleTypes.START_SCENE);
            } else {
                let msgData = { msg: '网络开了会儿小差，请稍后再试~', type: 'tips' }
                PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, msgData)
            }
        })
    }

    /**
     * 资源组加载出错
     */
    protected onResourceLoadError(event: RES.ResourceEvent): void {
        this.trace("preload组加载失败");
        //忽略加载失败的项目
        this.onResourceLoadComplete(event);
    }

    isIOS() {
        const u = navigator.userAgent;
        let isiOS = !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/);
        return isiOS;
    }

}

window['Main'] = Main;
egret.ImageLoader.crossOrigin = "anonymous";
egret.runEgret({
    renderMode: "canvas", audioType: 0, calculateCanvasScaleFactor: function (context: any) {
        var backingStore = context.backingStorePixelRatio ||
            context.webkitBackingStorePixelRatio ||
            context.mozBackingStorePixelRatio ||
            context.msBackingStorePixelRatio ||
            context.oBackingStorePixelRatio ||
            context.backingStorePixelRatio || 1;
        return (window.devicePixelRatio || 1) / backingStore;
    }
});