import SheetAnimation from "../components/SheetAnimation";
import { getResPath } from "../utils";
export default class Net extends egret.Sprite {
    private _pic: SheetAnimation;
    constructor() {
        super();
        this._pic = new SheetAnimation();
        this.addChild(this._pic);
        this.createBg();
        this.y = 600+30;
    }

    doAction() {
        if (!this._pic.sheet) return;
        this._pic.play();
        this._pic.addEventListener('frameUpdate', this.onEnterFrame, this);
    }

    onEnterFrame(e: egret.Event) {
        if (e.data == this._pic.totalFrames) {
            this._pic.removeEventListener('frameUpdate', this.onEnterFrame, this);
            this._pic.stopAtFirstFrame();
        }
    }

    createBg() {
        let url = getResPath() + `resource/assets/startScene/net.json`;
        RES.getResByUrl(url, (sheet: egret.SpriteSheet) => {
            this._pic.sheet = sheet;
            this._pic.fps = 20;
            this.alpha = 0;
            egret.Tween.get(this).to({ alpha: 1 }, 500);
            // setInterval(() => {
            //     this.doAction()
            // }, 5000);
            this.dispatchEvent(new egret.Event(egret.Event.COMPLETE));
        }, this, RES.ResourceItem.TYPE_SHEET);
    }
}