import { GetCreditsData } from './../../libs/tw/data/common/getCredits/GetCreditsData';
import { NetManager } from './../../libs/tw/manager/NetManager';
import { GCache } from './../../libs/tc/util/GCache';
import { GetInfoData } from './../../libs/tw/data/game/getInfo/GetInfoData';
import { DataManager } from './../../libs/tw/manager/DataManager';
import StartScene from './StartScene';
import GameConst from '../GameConst';
import fishesConfig from '../playScene/fishesConfig';
export default class ExStartScene extends StartScene {
    constructor() {
        super()
    }

    public bg: eui.Image;
    public title: eui.Image;
    public ruleBtn: eui.Button;
    public recordBtn: eui.Button;
    public startBtn: eui.Button;
    public optionBtn: eui.Button;
    public myCreditsTxt: eui.Label;
    public mainFish: eui.Image;
    public warningTips: eui.Label;

    public bubblePool: any[] = []; // 泡泡池
    public bubbleMoveCount: number = 0; // 泡泡移动计数
    public gameCount: number = 0; //  游戏计数
    public maxLevel: number = 1;

    /**
     * 初始化UI
     */
    protected initUI() {
        super.initUI();
        this.updateCostTxt();
        this.updateMyCredits();

        // 免责声明
        if (this.isIOS()) {
            this.warningTips.visible = true;
        } else {
            this.warningTips.visible = false;
        }

        this.maxLevel = Number(GCache.readCache(`maxLevel`));
        let fishTemp = this.mainFish.y;
        this.startBtn['btn'].alpha = 0;
        this.startBtn['btn'].touchEnable = false;
        this.title.y = -300;
        this.title.rotation = 60;
        let titleTW = egret.Tween.get(this.title);
        titleTW.to({ y: 180, rotation: -5 }, 300).to({ y: 224.5, rotation: 0 }, 200).call(() => {
            let startBtnTW0 = egret.Tween.get(this.startBtn['btn']);
            startBtnTW0.to({ alpha: 1 }, 300).call(() => {
                this.startBtn['btn'].touchEnable = true;
                let startBtnTW = egret.Tween.get(this.startBtn['btn'], { loop: true });
                startBtnTW.to({ scaleX: 1.2, scaleY: 1.2 }, 200).to({ scaleX: 1, scaleY: 1 }, 200).to({ scaleX: 1.2, scaleY: 1.2 }, 200).to({ scaleX: 1, scaleY: 1 }, 200).wait(200);
            })
        });

        setTimeout(() => {
            let fishTW = egret.Tween.get(this.mainFish, { loop: true });
            fishTW.to({ y: fishTemp - 100 }, 1500).to({ y: fishTemp + 100 }, 3000).to({ y: fishTemp }, 1500);
            for (let i = 0; i < 6; i++) {
                let bubble = new eui.Image;
                bubble.source = 'bubble_png';
                bubble.x = Math.max(Math.random() * 1, 0.5) * 750 / 6 + 750 / 6 * (i - 1);
                bubble['dir'] = [-1, 1][Math.round(Math.random() * (2 - 1))];
                bubble.y = GameConst.stage.stageHeight;
                bubble.scaleX = 0;
                bubble.scaleY = 0;
                this.addChild(bubble);
                this.addChild(this.mainFish);
                this.bubblePool.push(bubble);

                setTimeout(() => {
                    let bubbleTW = egret.Tween.get(bubble, { loop: true, onChange: this.updatebubble.bind(this) });
                    let nScaleX = Math.max(Math.random() * 1.6, 0.8);
                    let nY = GameConst.stage.stageHeight - 300;
                    bubbleTW.to({ scaleX: nScaleX, scaleY: nScaleX, y: nY }, 1000).to({ y: 300 }, 2500);
                }, Math.random() * 3000)
            }

            this.addChild(this.startBtn)
        }, 200);

        this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
    }

    onEnterFrame(e) {
        this.gameCount++;
        if (this.maxLevel) {
            if (Math.floor(this.gameCount / 15) % 2 == 0) {
                this.mainFish.source = `fishCLv${this.maxLevel}_png`;
                this.mainFish.width = fishesConfig.config[`lv${this.maxLevel}`].uW;
                this.mainFish.height = fishesConfig.config[`lv${this.maxLevel}`].uH;

            } else {
                this.mainFish.source = `fishOLv${this.maxLevel}_png`;
                this.mainFish.width = fishesConfig.config[`lv${this.maxLevel}`].uW;
                this.mainFish.height = fishesConfig.config[`lv${this.maxLevel}`].uH;
            }
        } else {
            if (Math.floor(this.gameCount / 15) % 2 == 0) {
                this.mainFish.source = `fishCLv1_png`;
                this.mainFish.width = fishesConfig.config[`lv1`].uW;
                this.mainFish.height = fishesConfig.config[`lv1`].uH;
            } else {
                this.mainFish.source = `fishOLv1_png`;
                this.mainFish.width = fishesConfig.config[`lv1`].uW;
                this.mainFish.height = fishesConfig.config[`lv1`].uH;
            }
        }
        this.mainFish.anchorOffsetX = this.mainFish.width / 2;
        this.mainFish.anchorOffsetY = this.mainFish.height / 2;

    }

    updatebubble(e) {
        this.bubbleMoveCount++;
        for (let i = 0; i < this.bubblePool.length; i++) {
            let speed = 0.3;
            let bubble = this.bubblePool[i];
            setTimeout(() => {
                bubble.x += Math.cos(this.bubbleMoveCount / 400) * bubble.dir * speed;
            }, (i + 1) * 200);
        }
    }

    updateCostTxt() {
        // 更新开始按钮的字
        let txt: string;
        if (DataManager.ins.getInfoData.status.code != 0) {
            txt = DataManager.ins.getInfoData.status.btnText;
        } else {
            txt = DataManager.ins.getInfoData.status.text;
        }
        this.startBtn['gameInfoTxt'].text = txt;
    }

    updateMyCredits() {
        if (DataManager.ins.getCreditsData && DataManager.ins.getCreditsData.unitName) {
            this.myCreditsTxt.text = `我的${DataManager.ins.getCreditsData.unitName}:${DataManager.ins.getInfoData.credits}`;
        } else {
            NetManager.ins.getCredits(() => {
                // console.log(data)
                this.myCreditsTxt.text = `我的${DataManager.ins.getCreditsData.unitName}:${DataManager.ins.getInfoData.credits}`;
            })
        }

        // this.myCreditsTxt.text = `我的积分:${DataManager.ins.getInfoData.credits}`;
    }

    isIOS() {
        const u = navigator.userAgent;
        let isiOS = !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/);
        return isiOS;
    }
}