import Panel from "../views/Panel";
import RankItem from "./RankItem";
import { DataManager } from '../../libs/tw/manager/DataManager';
import { NetManager } from '../../libs/tw/manager/NetManager';
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
export default class RankPanel extends Panel {
    public ruleBg:eui.Image;
    public closeBtn:eui.Button;
    public scroller:eui.Scroller;
    public group:eui.Group;
    public list:eui.List;
    public title:eui.Image;
    public dog:eui.Image;
    public rankNum:eui.Label;
    public userIdtxt:eui.Label;
    public scoretxt:eui.Label;
    public userItemBg:eui.Image;
    public userRankNum:eui.Label;
    public userId:eui.Label;
    public userScore:eui.Label;
    public num3:eui.Image;
    public num2:eui.Image;
    public num1:eui.Image;
    

    async start() {
        if (!DataManager.ins.realTimeRankData)
            NetManager.ins.realtimerank((success:boolean) => {
                if(success){
                    this.updatePanel();
                }
            },0);
        else
            this.updatePanel();
    }

    updatePanel() {
        if(DataManager.ins.realTimeRankData && DataManager.ins.realTimeRankData.myUserData){
            if(DataManager.ins.realTimeRankData.myUserData.rank == 1){
                this.num1.visible = true;
            }else if(DataManager.ins.realTimeRankData.myUserData.rank == 2){
                this.num2.visible = true;
            }else if(DataManager.ins.realTimeRankData.myUserData.rank == 3){
                this.num3.visible = true;
            }
            this.userId.text = `我`;
            this.userRankNum.text = DataManager.ins.realTimeRankData.myUserData && DataManager.ins.realTimeRankData.myUserData.rank ? `${DataManager.ins.realTimeRankData.myUserData.rank}` : '未上榜';
            this.userScore.text = DataManager.ins.realTimeRankData.myUserData && DataManager.ins.realTimeRankData.myUserData.maxScore ? `${DataManager.ins.realTimeRankData.myUserData.maxScore}` : '暂无分数';
            this.list.useVirtualLayout = false;
            this.list.itemRenderer = RankItem;
            const ac = new eui.ArrayCollection(DataManager.ins.realTimeRankData.userList);
            this.list.dataProvider = ac;
            
            // console.log(this.list.$children)
            setTimeout(()=>{
                this.list.$children.forEach((rankItem)=>{
                    if(rankItem['userRankNum'].text == 1){
                        rankItem['num1'].visible = true;
                    }else if(rankItem['userRankNum'].text == 2){
                        rankItem['num2'].visible = true;
                    }else if(rankItem['userRankNum'].text == 3){
                        rankItem['num3'].visible = true;
                    }
                })
            },50)    
        }else{
            
            this.userId.text = `我`;
            this.userRankNum.text = `未上榜`;
            this.userScore.text = `暂无分数`;
            if(DataManager.ins.realTimeRankData.userList){
                this.list.useVirtualLayout = false;
                this.list.itemRenderer = RankItem;
                const ac = new eui.ArrayCollection(DataManager.ins.realTimeRankData.userList);
                this.list.dataProvider = ac;
                
                // console.log(this.list.$children)
                setTimeout(()=>{
                    this.list.$children.forEach((rankItem)=>{
                        if(rankItem['userRankNum'].text == 1){
                            rankItem['num1'].visible = true;
                        }else if(rankItem['userRankNum'].text == 2){
                            rankItem['num2'].visible = true;
                        }else if(rankItem['userRankNum'].text == 3){
                            rankItem['num3'].visible = true;
                        }
                    })
                },50)
            }
        }
    }


    protected get skinKey() { return 'Rank' }
}