import { GameGetSubmitResultData } from '../../libs/tw/data/game/submit/GameGetSubmitResultData';
import { GetInfoData } from '../../libs/tw/data/game/getInfo/GetInfoData';
import Panel from "../views/Panel";
import { DataManager } from "../../libs/tw/manager/DataManager";
import getOptionImgSize from "./data/getOptionImgSize";
import ImgSizeType from "./data/ImgSizeType";
import { LotteryType } from "../../libs/tw/enum/LotteryType";
import { NetManager } from "../../libs/tw/manager/NetManager";
import showLog from "./ctrl/showLog";
import SceneCtrl from "../ctrls/sceneCtrl";
import Scene from '../views/Scene';
import { ModuleTypes } from "../types/sceneTypes";
import PanelCtrl from '../ctrls/panelCtrl';
export default class NoPrizePanel extends Panel {
    protected get skinKey() { return 'NoPrize' }

    public bg:eui.Image;
    public dog:eui.Image;
    public title:eui.Image;
    public againBtn:eui.Button;
    public costTxt:eui.Label;
    public scoreTxt:eui.Label;
    public maxScoreTxt:eui.Label;
    public closeBtn:eui.Button;

    start(data) {


        if(this.scoreTxt){
            this.scoreTxt.text = data.score;
        }
        
        if(this.maxScoreTxt){
            if(DataManager.ins.getInfoData && DataManager.ins.getInfoData.maxScore){
                if(Number(DataManager.ins.getInfoData.maxScore) < data.score){
                    this.maxScoreTxt.text = `我的最高分：${data.score}分`;;
                }else{
                    this.maxScoreTxt.text = `我的最高分：${DataManager.ins.getInfoData.maxScore}分`;
                }
            }else{
                this.maxScoreTxt.visible = false;
            }
        }
        
        NetManager.ins.getInfo((success)=>{
            if(!success) return;
            if(this.costTxt){
                this.costTxt.text = DataManager.ins.getInfoData.status.text;
            }
        })
    }

    initEvents() {
        super.initEvents();
        if(this.againBtn){
            this.againBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_AgainBtn, this);
        }
        if(this.closeBtn){
            this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_CloseBtn, this);
        }
    }

    private onTap_AgainBtn(e:egret.TouchEvent){
        this.againBtn.touchEnabled = false;
        if(DataManager.ins.getInfoData.status.code == 3){
            // 参与次数已用完
            let data = {msg:`今日次数已用完\n明日再来吧~`, type:'err'}
            PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, data)
            return;
        }else if(DataManager.ins.getInfoData.status.code == 2){
            // 积分不足
            let data = {msg:`积分不足\n去赚积分吧`, type:'creditsOut'}
            PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, data)
            return;
        }else if(DataManager.ins.getInfoData.status.code == 1){
            // 未登录
            let data = {msg:`未登录账号\n请先登录`, type:'requirelogin'}
            PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, data)
            return;
        }else{
            this.doStart(this.doStartResult.bind(this),false)
        }
        
    }

    public doStart(callback: Function, isAgain = false, credits?: number, customizedType?: number): void {
        if(window['requirelogin']) {
            window['requirelogin']();
            return;
        }
        NetManager.ins.doStart((success: boolean) => {
            if(success) {
                this.getStartOrderStatus(callback, customizedType);
            } else {
                callback(success);
            }
        },
        isAgain,
        credits,
        customizedType);
    }

    private getStartOrderStatus(callback: Function, customizedType?: number): void {
        NetManager.ins.getStartStatus(
            callback,
            DataManager.ins.doStartData.ticketId,
            () => { return DataManager.ins.getStartStatusData.code == 0; },
            5,
            customizedType);
    }

    // 开始的回调
    private doStartResult(success:boolean){
        
        if(!success) {
            return;
        }
        PanelCtrl.instance.closeCurrent();
        setTimeout(() => {
            SceneCtrl.instance.change(ModuleTypes.PLAY_SCENE);    
            this.againBtn.touchEnabled = true;
        }, 1000);
        
    }

    private onTap_CloseBtn(e:egret.TouchEvent){
        this.closeBtn.touchEnabled = false;
        PanelCtrl.instance.closeCurrentImmediately();
        SceneCtrl.instance.change(ModuleTypes.START_SCENE);
    }

}