import { TwLang } from './../../libs/tw/util/TwLang';
import { GFun } from './../../libs/tc/util/GFun';
import { DataManager } from '../../libs/tw/manager/DataManager';
import Scene from '../views/Scene';
export default class GameEndScene extends Scene {
    protected get skinKey() { return 'GameEnd' }

    constructor(){
        super();
        this.initUI();
    }

    public bg:eui.Image;
    public dark:eui.Rect;
    public userRankTxt:eui.Label;
    public dog:eui.Image;
    public userIdTxt:eui.Label;
    public prizeTxt:eui.Label;
    public useBtn:eui.Button;

    private initUI(){
        this.bg.y = egret.MainContext.instance.stage.stageHeight;

        if(this.userRankTxt){
            let txt:string;
            if(DataManager.ins.winRanksData.consumer.rank == "?") {
                txt =  GFun.replace(TwLang.lang_019, [DataManager.ins.winRanksData.consumer.rank || '0']);
            }else{
                GFun.replace(TwLang.lang_020, [DataManager.ins.winRanksData.consumer.rank]);
            }
            this.userRankTxt.text = txt;
        }

        if(this.userIdTxt){
            let txt:string;
            txt = GFun.replace(TwLang.lang_023, [DataManager.ins.winRanksData.consumer.cid])
            this.userIdTxt.text = txt;
        }

        if(this.prizeTxt){
            let txt: string;
            //是否参与过游戏
            if (DataManager.ins.winRanksData.consumer.join) {
                //是否中奖
                if (DataManager.ins.winRanksData.consumer.option) {
                    txt = GFun.replace(TwLang.lang_021, [DataManager.ins.winRanksData.consumer.option]);
                } else {
                    txt = TwLang.lang_022;
                }
            } else {
                txt = TwLang.lang_024;
            }
            this.prizeTxt.text = txt;
        }

    }


}