import Panel from "../views/Panel";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { Buried } from "../../libs/tw/util/Buried";
import GuidePanel from "../guidePanel/GuidePanel";
import { GDispatcher } from "../../libs/tc/util/GDispatcher";
import { GetSignResultData } from "../../libs/tw/data/pet/GetSignResultData";
import Loading from "../loading/Loading";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";

export class SignInScene extends Panel{
    public closeBtn:eui.Button;
    public signInBtn:eui.Button;
    public pMsgLb:eui.Label;
    // public guideBack: Function;
    // private guideLayer: GuidePanel;

    //设置加载emxl的路径名字
    public get skinKey() { return 'SignInScene' }
    public get groupName() { return 'signIn_panel' }

    constructor(data?){
        super(data);
    }

    public initEvents():void{
        super.initEvents();

        this.signInBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_signInBtn, this);
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_hidePanel, this);
    }

    public removeEvents():void{
        super.removeEvents();
        this.signInBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_signInBtn, this);
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_hidePanel, this);
    }

    start(data?:any){
		this.percentHeight 	= 100;
        // this.guideBack = data;
    }

    protected onSkinComplete():void{
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE,this.onLoad,this);
        if(this.stage){
            this.onLoad();
        }
        // if(this.guideBack){
        //     this.showGuide(2);
        // }
    }
    
    private onLoad():void{

        //签到页面曝光埋点
        const dpm = Buried.connectDpm(110, 4, 1);
        const dcm = Buried.connectDcm(230, window['skinID'], 0);
        const embedDomain = DataManager.ins.petIndexData.embedDomain;
        const exposure = Buried.createExposure(dpm, dcm, embedDomain);
        NetManager.ins.showLog(exposure);
        
        //设置签到ui初始
        this.setSignInDay();
    }

    private onClick_signInBtn():void{
        console.log('点击签到');

        Loading.instace.show();
        NetManager.ins.doSign(function(success:any){
			if(!success){
                Loading.instace.hide();
				return;
			}
            var logid:number = DataManager.ins.signInfoData.logId;
            NetManager.ins.getSignResult(function(success:any){
                Loading.instace.hide();
                if(success == 'pollingFaild' || !success){
                    PanelCtrl.instance.show(ModuleTypes.MSG_PANEL,["网络问题，金币稍后到账哦～"], false);
                    
                    return;
                }
                var acmDays:number = DataManager.ins.signInfoData.signInfoVO.acmDays;
                this['awardState' + (acmDays - 1)].visible = true;
                this.signInBtn.enabled = false;
    
                console.log('DataManager.ins.signInfoData.signInfoVO.rewardMap=' ,DataManager.ins.signInfoData.signInfoVO.rewardMap); //奖品列表
                DataManager.ins.petIndexData.credits += DataManager.ins.signInfoData.signInfoVO.rewardMap.CIRCLE.credits;
                GDispatcher.dispatchEvent('refreshCredits');
                GDispatcher.dispatchEvent('refreshSignIn');
    
                this.pMsgLb.text = '已连续签到' + acmDays + '天';
                
            }.bind(this),logid,function(data:GetSignResultData){//返回true，表示继续循环
                console.log('签到data.status=' + data.status);
                return data.status != 2;
            });
        }.bind(this), window['signActivityId']);
        //点击埋点，确认签到
        const dpm = Buried.connectDpm(110, 4, 1);
        const dcm = Buried.connectDcm(230, window['skinID'], 0);
        const embedDomain = DataManager.ins.petIndexData.embedDomain;
        const exposure = Buried.createExposure(dpm, dcm, embedDomain);
        NetManager.ins.clickLog(exposure);

        // if(this.guideBack){
        //     this.hideGuide();
        // }
    }

    private setSignInDay():void{
        var acmDays:number = DataManager.ins.signInfoData.signInfoVO.acmDays;
        for(var i:number = 0; i < 7; i++){
            if(i < acmDays){//已签到
                this['awardState' + i].visible = true;
            }else{
                this['awardState' + i].visible = false;
            }
            
        }

        this.signInBtn.enabled = !DataManager.ins.signInfoData.signInfoVO.todaySigned;
        this.pMsgLb.text = '已连续签到' + acmDays + '天';
    }

    private onClick_hidePanel():void{
        // if(this.guideBack){
        //     this.hideGuide();
        //     this.guideBack(3);
        // }
        super.hidePanel();
    }

    // private showGuide(index:number):void{
    //     this.hideGuide();
	// 	if(!this.guideLayer){
	// 		this.guideLayer = new GuidePanel();
	// 		this.addChild(this.guideLayer);
    //     }
        
    //     const thisH = Math.floor(750 / document.body.clientWidth * document.body.clientHeight)
    //     const w = 422;
    //     const h = 114;
    //     const x = this.signInBtn.x;
    //     const y = thisH - this.signInBtn.bottom - (h+5);
    //     this.guideLayer.updateData(index, x, y, w, h)
    // }

	// private hideGuide():void{
	// 	if(this.guideLayer){
	// 		this.guideLayer.dispose();
	// 		this.removeChild(this.guideLayer);
	// 		this.guideLayer = null;
	// 	}
	// }
}