import { LotteryType } from '../../libs/tw/enum/LotteryType';
import { TwFun } from './../../libs/tw/util/TwFun';
import { GetPlugOrderStatusData } from './../../libs/tw/data/plug/doJoinPlugDraw/GetPlugOrderStatusData';
import { DataManager } from '../../libs/tw/manager/DataManager';
import Panel from "../views/Panel";

export class SignInPrizePanel extends Panel {
    private mdata: any;
    public noPrizeGroup: eui.Group;
    public prizeGroup: eui.Group;
    public prizeImg: eui.Image;
    public closeBtn: eui.Button;

    private lottery: any;
    private hasPrize: boolean = false;

    constructor(data?) {
        super(data)

        this.hasPrize = data;
        this.mdata = DataManager.ins.getPlugOrderStatusData;
        this.lottery = DataManager.ins.getPlugOrderStatusData.lottery;
    }


    onSkinComplete() {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
        if (this.hasPrize) {
            // 有奖
            this.prizeImg.source = `${DataManager.ins.getPlugOrderStatusData.lottery.img}`
            this.noPrizeGroup.visible = false;
            this.prizeGroup.visible = true;
        } else {
            // 没奖
            this.noPrizeGroup.visible = true;
            this.prizeGroup.visible = false;
        }
    }

    onLoad() {
        if (this.mdata && this.lottery) {
            var url: string;

            url = this.lottery.img;
            this.prizeImg.name = 'img'

            // this.prizeNameLb.text = this.lottery.name;//该项目用不到
            this.prizeImg.source = url;

            switch (this.lottery.type) {
                case LotteryType.VIRTUAL:
                case LotteryType.OBJECT:
                case LotteryType.ALIPAY:
                case LotteryType.PHONEBILL:
                case LotteryType.QB:
                    this.prizeImg.x = 253;
                    this.prizeImg.y = 435;

                    this.prizeImg.width = 243;
                    this.prizeImg.height = 243;
                    break;

                // case LotteryType.THANKS:

                // break;

                default:

                    this.prizeImg.x = 118;
                    this.prizeImg.y = 435;

                    this.prizeImg.width = 515;
                    this.prizeImg.height = 243;
                    break;
            }
        }
    }


    initEvents() {
        super.initEvents();
        this.prizeImg.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_prizeImg, this);
    }

    onTap_prizeImg() {
        window.location.href = TwFun.getRecordUrl('01');
    }

    //设置加载emxl的路径名字
    public get skinKey() { return 'SignInPrizePanel' }
    public get groupName() { return 'signIn_prize_panel' }
}