import { Buried } from './../../libs/tw/util/Buried';
import { ModuleTypes } from './../types/sceneTypes';
import Panel from "../views/Panel";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import Loading from "../loading/Loading";
import PanelCtrl from "../ctrls/panelCtrl";
export class SignInPanel extends Panel {
    public con: eui.Group;
    public dayGroup0: eui.Group;
    public dayLb0: eui.Label;
    public coinName0: eui.Label;
    public dayGroup1: eui.Group;
    public dayLb1: eui.Label;
    public coinName1: eui.Label;
    public dayGroup2: eui.Group;
    public dayLb2: eui.Label;
    public coinName2: eui.Label;
    public dayGroup3: eui.Group;
    public dayLb3: eui.Label;
    public coinName3: eui.Label;
    public dayGroup4: eui.Group;
    public dayLb4: eui.Label;
    public coinName4: eui.Label;
    public dayGroup5: eui.Group;
    public dayLb5: eui.Label;
    public coinName5: eui.Label;
    public dayGroup6: eui.Group;
    public dayLb6: eui.Label;
    public coinName6: eui.Label;
    public closeBtn: eui.Button;
    public guideTips: eui.Image;
    public fingerUp: eui.Image;

    private scene: any;
    private isGuide: boolean;

    //设置加载emxl的路径名字
    public get skinKey() { return 'SignInPanel' }
    public get groupName() { return 'signIn_panel' }

    constructor(data) {
        super(data)

        this.scene = data.scene;
        this.isGuide = data.isGuide;
    }

    public initEvents(): void {
        // super.initEvents();

        if (!this.isGuide) {
            this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_hidePanel, this);
        }
    }

    public removeEvents(): void {
        super.removeEvents();
        for (let i = 0; i < 7; i++) {
            this[`dayGroup${i}`].removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_signInBtn, this);
        }
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_hidePanel, this);
    }


    protected onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
        if (this.isGuide) {
            this.guideTips.visible = true;
            // this.fingerUp.visible = true;

            // egret.Tween.get(this.fingerUp, { loop: true })
            //     .to({ scaleX: 0.8, scaleY: 0.8 }, 330)
            //     .to({ scaleX: 1, scaleY: 1 }, 330)

            // this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
        }
        // if(this.guideBack){
        //     this.showGuide(2);
        // }
    }

    // private fingerCount: number = 0;
    // onEnterFrame() {
    //     this.fingerCount++;
    //     if (this.fingerCount % 10 == 0 && (this.fingerCount / 10) % 2 == 0) {
    //         this.fingerUp.visible = false;
    //     } else if (this.fingerCount % 10 == 0 && (this.fingerCount / 10) % 2 == 1) {
    //         this.fingerUp.visible = true;
    //     }
    // }

    private onLoad(): void {

        //签到页面曝光埋点
        // const dpm = Buried.connectDpm(110, 4, 1);
        // const dcm = Buried.connectDcm(230, window['skinID'], 0);
        // const embedDomain = DataManager.ins.petIndexData.embedDomain;
        // const exposure = Buried.createExposure(dpm, dcm, embedDomain);
        // NetManager.ins.showLog(exposure);

        //设置签到ui初始
        this.setSignInDay();
    }

    // 设置签到ui初始
    private setSignInDay(): void {
        // 周期内连续签到天数
        const continueDay: number = Number(DataManager.ins.signInfoData.signInfoVO.continueDay);
        // 今日是否签到
        const todaySigned: boolean = DataManager.ins.signInfoData.signInfoVO.todaySigned;
        for (let i = 0; i < 7; i++) {
            if (i < continueDay) {
                this[`btn${i}`].source = `signIn_btnBg_on_png`;
                this[`coinName${i}`].textColor = '0xe19d27';
            }
        }
        if (!todaySigned) {
            // 今日未签到
            // this[`dayGroup${continueDay}`].addEventListener(egret.TouchEvent.TOUCH_BEGIN, () => {
            //     this[`dayGroup${continueDay}`].scaleX = 0.8;
            //     this[`dayGroup${continueDay}`].scaleY = 0.8;
            // }, this);
            // this[`dayGroup${continueDay}`].addEventListener(egret.TouchEvent.TOUCH_END, () => {
            //     this[`dayGroup${continueDay}`].scaleX = 1;
            //     this[`dayGroup${continueDay}`].scaleY = 1;
            // }, this);
            // this[`dayGroup${continueDay}`].addEventListener(egret.TouchEvent.TOUCH_CANCEL, () => {
            //     this[`dayGroup${continueDay}`].scaleX = 1;
            //     this[`dayGroup${continueDay}`].scaleY = 1;
            // }, this);
            // this[`dayGroup${continueDay}`].addEventListener(egret.TouchEvent.TOUCH_RELEASE_OUTSIDE, () => {
            //     this[`dayGroup${continueDay}`].scaleX = 1;
            //     this[`dayGroup${continueDay}`].scaleY = 1;
            // }, this);
            // this[`dayGroup${continueDay}`].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_signInBtn, this);
            if (this.isGuide) {
                setTimeout(() => {
                    let e = { $target: this[`btn${continueDay}`] }
                    this.onClick_signInBtn(e);
                }, 3000);
            } else {
                setTimeout(() => {
                    let e = { $target: this[`btn${continueDay}`] }
                    this.onClick_signInBtn(e);
                }, 1000);
            }


        }

        // this.signInBtn.enabled = !DataManager.ins.signInfoData.signInfoVO.todaySigned;
        // this.pMsgLb.text = '已连续签到' + acmDays + '天';
    }

    private onClick_signInBtn(e): void {
        Loading.instace.show();
        const target = e.$target;
        // 周期内连续签到天数
        let continueDay: number = Number(DataManager.ins.signInfoData.signInfoVO.continueDay);
        // 今日是否签到
        const todaySigned: boolean = DataManager.ins.signInfoData.signInfoVO.todaySigned;
        if (todaySigned) {
            PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, ["今天已经签过到了~"], false);
            return
        }
        NetManager.ins.doSign((s) => {
            Loading.instace.hide();
            if (!s) {
                //如果失败，按原先天数算进度？
                // PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, ["签到失败，请重试~"], false);
                return
            }
            console.log(DataManager.ins.signInfoData.signInfoVO);
            let continueDay = Number(DataManager.ins.signInfoData.signInfoVO.continueDay);
            if (continueDay > 0) {
                this[`dayGroup${continueDay - 1}`].removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_signInBtn, this);
            }
            if (continueDay > 7) {
                this[`dayGroup${continueDay}`].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_signInBtn, this);
            }


            for (let i = 0; i < 6; i++) {
                if (target == this[`btn${i}`]) {
                    this[`btn${i}`].source = `signIn_btnBg_on_png`;
                    this[`coinName${i}`].textColor = '0xe19d27';
                }
            }

            setTimeout(() => {
                let continueDay = Number(DataManager.ins.signInfoData.signInfoVO.continueDay);
                if (continueDay == 7) {
                    // 签到第七天 
                    if (DataManager.ins.signInfoData.signInfoVO.rewardMap && DataManager.ins.signInfoData.signInfoVO.rewardMap.CIRCLE && DataManager.ins.signInfoData.signInfoVO.rewardMap.CIRCLE.plActId) {
                        // 调用插件抽奖
                        const plugId: number = DataManager.ins.signInfoData.signInfoVO.rewardMap.CIRCLE.plActId;
                        Loading.instace.show();
                        NetManager.ins.doJoinPlugDraw((ss) => {
                            Loading.instace.hide();
                            if (!ss) {
                                // 失败弹窗
                                this.onClick_hidePanel();
                                PanelCtrl.instance.show(ModuleTypes.SIGN_IN_PRIZE_PANEL, false);
                                return
                            }
                            NetManager.ins.getPlugOrderStatus(
                                (sss) => {
                                    if (sss) {
                                        if (target == this[`btn6`] && this[`awardState6`]) {
                                            this[`awardState6`].visible = true
                                        }
                                        this.onClick_hidePanel();
                                        PanelCtrl.instance.show(ModuleTypes.SIGN_IN_PRIZE_PANEL, true)
                                    } else {
                                        this.onClick_hidePanel();
                                        PanelCtrl.instance.show(ModuleTypes.SIGN_IN_PRIZE_PANEL, false);
                                    }
                                },
                                DataManager.ins.doJoinPlugDrawData.orderId,
                                () => {
                                    return DataManager.ins.getPlugOrderStatusData.result == 0
                                }
                            )

                        }, plugId)
                    } else {
                        // 关闭弹窗 出奖品赶来弹窗
                        setTimeout(() => {
                            this.onClick_hidePanel();
                            PanelCtrl.instance.show(ModuleTypes.SIGN_IN_PRIZE_PANEL, false);
                        }, 500);
                    }
                } else {
                    // 关闭弹窗 出金币动画
                    this.onClick_hidePanel();
                    PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, ["签到成功"], false, 1000);
                    // 调用主页面更新积分动效方法

                    setTimeout(() => {
                        this.scene.signSucAni();
                    }, 1000);

                }
            }, 500);
        },
            window["signActivityId"]
        )
    }

    private onClick_hidePanel(): void {
        // if(this.guideBack){
        //     this.hideGuide();
        //     this.guideBack(3);
        // }
        super.hidePanel();
    }

}