
import Panel from "../views/Panel";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import GuidePanel from "../guidePanel/GuidePanel";
export default class RewardPanel extends Panel {
    private closeBtn: eui.Button;
    private rwdImg: eui.Image;
    private titleTxt: eui.Label;
    private txt: eui.Label;
    private lookBtn: eui.Button;

    // public guideBack: Function;
    // private guideLayer: GuidePanel;
    private curMapType: number;
    private d: any;

    public get skinKey() { return 'Reward' }
	public get groupName() { return 'reward_panel'}
    constructor(data?){
        super(data);
    }

    start(data?):void{
        this.percentHeight = 100;
        var mapPlugIDList = window['mapPlugIDList'] ? window['mapPlugIDList'] : [1,1];
        if(mapPlugIDList[0] == data[0]){
            this.curMapType = 0;
        }else if(mapPlugIDList[1] == data[0]){
            this.curMapType = 1;
        }
        this.d = data[1];
    }

    protected onSkinComplete():void{
        super.onSkinComplete();
        this.updateData();

        // this.guideBack = this.d;
        // if(this.guideBack){
		// 	this.showGuide(9);
        // }
    }

    updateData():void{
        const lottery = DataManager.ins.getPlugOrderStatusData.lottery;
        this.titleTxt.text = '小海豚从' + lottery.name + '回来啦';
        this.txt.text = '给你带了张明信片，快去看看吧';
        if(lottery){
            this.rwdImg.source = lottery.img;
        }
    }

    /**
     * 查看相册
     * @param e 
     */
    private onClick_lookBtn(e:egret.TouchEvent):void{
        if(DataManager.ins.getPlugOrderStatusData.lottery && DataManager.ins.getPlugOrderStatusData.lottery.type == 'collectGoods'){
            //中了集卡，那么就重新获取集卡数据，刷新集卡数量
            NetManager.ins.getCollectRule(()=>{
                NetManager.ins.getCollectGoodsInfo(() => {
                    // if(this.guideBack){
                    //     PanelCtrl.instance.show(ModuleTypes.ALBUM_PANEL, this.guideBack);
                    // }else{
                        PanelCtrl.instance.show(ModuleTypes.ALBUM_PANEL);
                    // }
                }, window['collectRuleIdList'] ? window['collectRuleIdList'][this.curMapType] : 1);
            }, window['collectRuleIdList'] ? window['collectRuleIdList'][this.curMapType] : 1);
        }
        this.hidePanel();
    }

    initEvents():void{
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.hidePanel, this);
        this.lookBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_lookBtn, this);
    }

    removeEvents():void{
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.hidePanel, this);
        this.lookBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_lookBtn, this);
    }

    // private showGuide(index:number):void{
    //     this.hideGuide();
	// 	if(!this.guideLayer){
	// 		this.guideLayer = new GuidePanel();
	// 		this.addChild(this.guideLayer);
    //     }
        
    //     const thisH = Math.floor(750 / document.body.clientWidth * document.body.clientHeight)
    //     let w;
    //     let h;
    //     let x;
    //     let y;
    //     if(index == 9){//指向使用按钮
    //         w = 422;
    //         h = 114;
    //         x = this.lookBtn.x;
    //         y = thisH / 2 + this.lookBtn.verticalCenter - (h+10)/2;
    //     }
    //     this.guideLayer.updateData(index, x, y, w, h)
    // }

	// private hideGuide():void{
	// 	if(this.guideLayer){
	// 		this.guideLayer.dispose();
	// 		this.removeChild(this.guideLayer);
	// 		this.guideLayer = null;
	// 	}
	// }
}