import Panel from "../views/Panel";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import MyCoinLogItem from "./MyCoinLogItem"
import { DataManager } from "../../libs/tw/manager/DataManager";
import { IWeOrderListData } from "../../libs/tw/data/customMade/IWeOrderListData";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { Buried } from "../../libs/tw/util/Buried";
/**
 * 我的金币界面
 */
export default class MyGoldCoinPanel extends Panel {
    public closeBtn: eui.Button;
    private numTxt: eui.Label;
    private coinIcon: eui.Image;
    private linkTxt: eui.Label;
    private ary: eui.ArrayCollection;
    private list: eui.List;
    private scroller: eui.Scroller;
    private listData: any = [];
    private curPage: number;
    private lock:boolean;//防止连续发接口
	public get skinKey() { return 'MyGoldCoin' }
	public get groupName() { return 'myGoldCoin_panel'}
    constructor(data?){
        super(data);
    }

	start(data?){
		this.percentHeight = 100;
    }

    protected onSkinComplete():void{
        super.onSkinComplete();
        this.init();

        //曝光埋点，我的金币记录页
        const dpm = Buried.connectDpm(110, 7, 1);
        const dcm = Buried.connectDcm(230, window['skinID'], 0);
        const embedDomain = DataManager.ins.petIndexData.embedDomain;
        const exposure = Buried.createExposure(dpm, dcm, embedDomain);
        NetManager.ins.showLog(exposure);
    }

    private init():void{
        this.lock = false;
        this.curPage = 1;
        this.listData = [];
        const credits = DataManager.ins.petIndexData.credits + ''
        this.numTxt.text = credits;
        this.coinIcon.x = Math.min((credits.length * 60 + this.numTxt.x), 450);
        this.linkTxt.textFlow = new Array<egret.ITextElement>(
            {text:'赚金币>', style:{ underline:true }}
        )
        this.ary = new eui.ArrayCollection();
        var list = new eui.List();
        list.dataProvider = this.ary;
        list.itemRenderer = MyCoinLogItem;
        list.width = 640;
        list.height = 270;
        this.addChild(list);
        this.list = list;
        this.list.addEventListener(egret.TouchEvent.TOUCH_MOVE, this.move, this);
        var scroller = new eui.Scroller();
        this.scroller = scroller;
        this.scroller.viewport = this.list;
        this.addChild(this.scroller);
        this.scroller.x = 55;
        this.scroller.bottom = 27;
        this.updateData();
    }

    move(e:egret.TouchEvent):void{
        const listH = this.listData.length * 80;//80是单个item的高度
        var len:number = DataManager.ins.weOrderData.list.length;
        var maxCount:number = 10;
        if(DataManager.ins.weOrderData.list.length < maxCount){
            return;
        }

        if(this.scroller.viewport.scrollV > (listH - this.list.height)){// - 80 - this.list.height)){ //下拉到了最后一个item，就发接口获取下一页的10条数据
            if(this.lock){//接口返回之前不能连续发送
                return;
            }
            this.lock = true;
            this.curPage++;//当前页数+1
            NetManager.ins.weOrder((success:boolean) => {
                if(!success){
                    return;
                }
                this.lock = false;
                this.updateData();
            }, DataManager.ins.petIndexData.appId, DataManager.ins.petIndexData.partnerUserId, this.curPage, maxCount, 'success');
        }
        
    }
    
    public updateData():void{
        this.setListData(DataManager.ins.weOrderData.list);
        this.ary.replaceAll(this.listData);
    }

    /**
     * 更新当前列表的数据，把每次调接口获取的累加起来
     * @param d 
     */
    private setListData(d:IWeOrderListData[]):void{
        if(d){
            for(let i=0; i<d.length; i++){
                this.listData.push(d[i]);
            }
        }
    }

    private onClick_earnGoldCoinPanel(e):void{
        this.hidePanel();
        PanelCtrl.instance.show(ModuleTypes.EARN_GOLD_COIN_PANEL);
    }

    initEvents():void{
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.hidePanel, this);
        this.linkTxt.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_earnGoldCoinPanel, this)
    }

    removeEvents() {
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.hidePanel, this);
        this.linkTxt.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_earnGoldCoinPanel, this)
    }
}