import { getSkinPath } from "../utils";

/**
 * 单条收支记录
 */
export default class MyCoinLogItem extends eui.ItemRenderer {
    private title: eui.Label;
    private numLab: eui.Label;
    private dateLab: eui.Label;
    constructor(data?){
        super();
        this.skinName = getSkinPath('MyCoinLogItem');
        this.touchChildren = true;
        this.init();
    }

    public init():void{
        // this.height = 80;
    }
    
    /**
     * 数据更新
     * 此方法必须实现
     */
    public dataChanged():void{
        // 将数据对应到组件上
        if(this.data && this.data.description){
            var des:string = this.data.description;
            if(this.data.activityType == 'virtual'){
                if(this.data.params == 'DBJF_10'){
                    des = '每日分享';
                }else if(this.data.params == 'DBJF_200'){
                    des = '新人奖励';
                }
            }

            this.title.text = des;
            this.numLab.text = this.data.bizType == 'add' ? '+' + this.data.credits : "-" + this.data.credits;
            var date:Date = new Date(this.data.gmtCreate);
            this.dateLab.text = date.getFullYear() + '.' + (date.getMonth() + 1) + '.' + date.getDate();
        }
    }
}