export class FoodItem extends eui.Component{
    // public act:egret.tween.TweenGroup;
    public foodNumLb:eui.Label;
    public lightImg:eui.Image;
    public fcount:number;
    //场景中的固定位置
    public pos:number;
    //食物id
    public fid:number;
    //点击收取回调
    private clickCallBack:Function;
    //运动方向
    public dir:number;
    
    /**
     * @param id 食物id
     * @param count 食物数量
     * @param pos 显示位置
     * @param dir 运动方向
     */
    constructor(id:number,count:number,pos:number, dir:number,callBack:Function){
        super();
        this.skinName       = 'resource/skins/component/FoodComponent.exml';
        this.fcount         = count;
        this.pos            = pos;
        this.fid            = id;
        this.dir            = dir;
        this.clickCallBack  = callBack;

        this.addEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);
        if (this.skin) {
            this.onSkinComplete();
        }
    }

    private onSkinComplete():void{
        this.foodNumLb.text = this.fcount + 'g';
        // this.act.items[0].props = {loop:true};

        this.foodNumLb.touchEnabled = false;
        this.removeEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);
        this.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick,this);

        egret.Tween.get(this.lightImg, {loop:true}).to({alpha:0.2}, 1500).to({alpha:1}, 1500);
    }

    public removeEvent():void{
        this.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick,this);
    }

    private onClick():void{
        if(this.clickCallBack){
            this.clickCallBack(this);
        }
    }
    
    public playAct(start:number = 0):void{
        let time = 700;
        egret.Tween.removeTweens(this);
        egret.Tween.get(this, {loop:true}).to({y:-10 * this.dir}, time).to({y:0}, time).to({y:10 * this.dir}, time).to({y:0}, time);
        // this.act.play(start);
    }

    public stopAct():void{
        // this.act.stop();
    }
}