import { TwFun } from './../../libs/tw/util/TwFun';
import { GetPlugOrderStatusData } from './../../libs/tw/data/plug/doJoinPlugDraw/GetPlugOrderStatusData';
import { DataManager } from '../../libs/tw/manager/DataManager';
import Panel from "../views/Panel";

export class GuidePrizePanel extends Panel {

    public noPrizeGroup: eui.Group;
    public prizeGroup: eui.Group;
    public acceptBtn: eui.Button;
    public closeBtn: eui.Button;


    private hasPrize: boolean = false;

    constructor(data?) {
        super(data)

        this.hasPrize = data;
    }

    onSkinComplete() {
        super.onSkinComplete();
        if (this.hasPrize) {
            // 有奖
            // this.prizeImg.source = `${DataManager.ins.getPlugOrderStatusData.lottery.img}`
            this.noPrizeGroup.visible = false;
            this.prizeGroup.visible = true;
        } else {
            // 没奖
            this.noPrizeGroup.visible = true;
            this.prizeGroup.visible = false;
        }
    }

    initEvents() {
        super.initEvents();
        this.acceptBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_acceptBtn, this);
    }

    onTap_acceptBtn() {
        this.hidePanel();
    }

    //设置加载emxl的路径名字
    public get skinKey() { return 'GuidePrize' }
    public get groupName() { return 'guide_component' }
}