
import Panel from "../views/Panel";
import ComponentBase from "../components/ComponentBase";
export default class GuidePanel extends ComponentBase {
    private topMask: eui.Rect;
    private leftMask: eui.Rect;
    private rightMask: eui.Rect;
    private bottomMask: eui.Rect;
    private hand: eui.Group;
    private tw1: egret.Tween;
    private tw2: egret.Tween;

    private handX:number;
    private handY:number;

    private index:number;
    private xx:number;
    private yy:number;
    private ww:number;
    private hh:number;
    private tip:string;

    public get skinKey() { return 'Guide' }
	public get groupName() { return 'guide_panel'}
    constructor(data?){
        super(data);
    }

    start(data?):void{
        // this.percentHeight = 100;
    }

    protected onSkinComplete():void{
        this.updateData(this.index, this.xx, this.yy, this.ww, this.hh, this.tip);
    }

    /**
     * 
	 * @param index : 当前引导的步数
	 * @param x : 指引位置的x坐标
	 * @param y : 指引位置的y坐标
	 * @param w : 指引位置的宽度
	 * @param h : 指引位置的高度
	 * @param tips : 引导提示文字
     */
    public updateData(index:number, x:number, y:number, w:number, h:number, tips?: string):void{
        console.log('x:'+x,'y:'+y,'w:'+w,'h:'+h);
        this.index = index;
        this.xx = x;
        this.yy = y;
        this.ww = w;
        this.hh = h;
        this.tip = tips;
        if(!this.topMask)return;
        this.topMask.x = 0;
        this.topMask.y = 0;
        this.topMask.width = 750;
        this.topMask.height = y;

        this.leftMask.x = 0;
        this.leftMask.y = y;
        this.leftMask.width = x;
        this.leftMask.height = h;

        this.rightMask.x = x+w;
        this.rightMask.y = y;
        this.rightMask.width = 750 - (x + w);
        this.rightMask.height = h;

        this.bottomMask.x = 0;
        this.bottomMask.y = y + h;
        this.bottomMask.width = 750;
        this.bottomMask.height = 1624 - (y + h);

        if(this.tw1){
            egret.Tween.removeTweens(this.tw1);
        }
        if(this.tw2){
            egret.Tween.removeTweens(this.tw2);
        }
        this.handX = x-this.hand.width;
        this.handY = y+this.hand.height;
        this.hand.x = x-this.hand.width;
        this.hand.y = y+this.hand.height;
        
        this.playHand();

        this['tips'].visible = false;
        if(tips){
            this['tips'].visible = true;
            this['txt'].text = tips;
            const tipsW = Math.min(tips.length, 14) * 32 + 100;
            if(index == 1){//指向签到按钮
                this['tips'].x = (750 - tipsW) / 2;
                this['tips'].y = this.handY + 100;
            }else if(index == 3){//指向鱼食
                this['tips'].x = (750 - tipsW) / 2;
                this['tips'].y = this.handY + 100;
            }else if(index == 5){//指向出游按钮
                this['tips'].x = (750 - tipsW) / 2;
                this['tips'].y = this.handY - 190;
            }else if(index == 8){//指向道具按钮
                this['tips'].x = (750 - tipsW) / 2;
                this['tips'].y = this.handY + 100;
            }else if(index == 10){//指向赚金币按钮
                this['tips'].x = (750 - tipsW) / 2;
                this['tips'].y = this.handY - 190;
            }
        }
    }

    
    /**
     * 手型缓动
     */
    private playHand():void{
        this.tw1 = egret.Tween.get(this.hand).to({x:this.handX + 30, y:this.handY - 30},300).call(function(){
            this.recover();
        },this);
    }

    /**
     * 恢复到原先位置
     */
    recover():void{
        this.tw2 = egret.Tween.get(this.hand).to({x:this.handX, y:this.handY},300).call(function(){
            this.playHand();
        },this);
    }

    public dispose():void{
        if(this.tw1){
            egret.Tween.removeTweens(this.tw1);
        }
        if(this.tw2){
            egret.Tween.removeTweens(this.tw2);
        }
        this.hand.x = this.handX;
        this.hand.y = this.handY;
    }
}