
import Panel from "../views/Panel";
// import { NetManager } from '../../libs/tw/manager/NetManager';
// import { DataManager } from "../../libs/tw/manager/DataManager";
export default class GuidePanel extends Panel {
    public maskRule:eui.Rect;
    public okBtn:eui.Button;
    private callback:Function;
    constructor(data){
        super(data);
        this.callback       = data;
        this.percentHeight  = 100;
    }

    protected onSkinComplete():void{
        super.onSkinComplete();
        this.maskRule.alpha = 0;
        egret.Tween.get(this.maskRule).to({alpha:1},1000);
        
    }

    public initEvents():void{
        super.initEvents();
        this.okBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
    }

    private onTap():void{
        if(this.callback){
            this.callback();
        }
        this.hidePanel();
    }

    public removeEvents():void{
        super.removeEvents();
    }

    public get skinKey() { return 'Guide' }
	public get groupName() { return 'guide_panel'}
}