import { TwFun } from './../../libs/tw/util/TwFun';
import { GetPlugOrderStatusData } from './../../libs/tw/data/plug/doJoinPlugDraw/GetPlugOrderStatusData';
import { DataManager } from '../../libs/tw/manager/DataManager';
import Panel from "../views/Panel";

export class ExtraPrizePanel extends Panel {

    public prizeGroup: eui.Group;
    public acceptBtn: eui.Button;
    public extraTips: eui.Image;
    public extraTitle: eui.Image;
    public closeBtn: eui.Button;


    private isPrize: boolean = false;

    constructor(data?) {
        super(data)
        this.isPrize = data;
    }

    onSkinComplete() {
        super.onSkinComplete();

        if (!this.isPrize) {
            this.extraTips.visible = false;
            this.acceptBtn.visible = false;
            this.extraTitle.y = 170;
        }
    }

    initEvents() {
        super.initEvents();
        this.acceptBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_acceptBtn, this);
    }

    onTap_acceptBtn() {
        this.hidePanel();
    }

    //设置加载emxl的路径名字
    public get skinKey() { return 'ExtraPrize' }
    public get groupName() { return 'extra_prize_panel' }
}