import Panel from "../views/Panel";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { Buried } from "../../libs/tw/util/Buried";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { GDispatcher } from "../../libs/tc/util/GDispatcher";
import Loading from "../loading/Loading";
/**
 * 赚金币界面
 */
export default class EarnGoldCoinPanel extends Panel {
    public con: eui.Group;
    public dayGroup0: eui.Group;
    public btn0: eui.Image;
    public dayLb0: eui.Label;
    public numLb0: eui.Label;
    public coinName0: eui.Label;
    public awardState0: eui.Image;
    public dayGroup1: eui.Group;
    public btn1: eui.Image;
    public dayLb1: eui.Label;
    public numLb1: eui.Label;
    public coinName1: eui.Label;
    public awardState1: eui.Image;
    public dayGroup2: eui.Group;
    public btn2: eui.Image;
    public dayLb2: eui.Label;
    public numLb2: eui.Label;
    public coinName2: eui.Label;
    public awardState2: eui.Image;
    public dayGroup3: eui.Group;
    public btn3: eui.Image;
    public dayLb3: eui.Label;
    public numLb3: eui.Label;
    public coinName3: eui.Label;
    public awardState3: eui.Image;
    public dayGroup4: eui.Group;
    public btn4: eui.Image;
    public dayLb4: eui.Label;
    public numLb4: eui.Label;
    public coinName4: eui.Label;
    public awardState4: eui.Image;
    public dayGroup5: eui.Group;
    public btn5: eui.Image;
    public dayLb5: eui.Label;
    public numLb5: eui.Label;
    public coinName5: eui.Label;
    public awardState5: eui.Image;
    public dayGroup6: eui.Group;
    public btn6: eui.Image;
    public dayLb6: eui.Label;
    public numLb6: eui.Label;
    public coinName6: eui.Label;
    public awardState6: eui.Image;
    public closeBtn: eui.Button;


    private scene: any;

    public get skinKey() { return 'EarnGoldCoin' }
    public get groupName() { return 'earnGold_panel' }

    constructor(data?) {
        super(data);

        if (data) {
            this.scene = data.scene;
        }

    }

    private init(): void {
        this.updateData();
    }

    start() {
        this.percentHeight = 100;
    }

    protected onSkinComplete(): void {
        super.onSkinComplete();

        //赚金币曝光埋点
        const dpm = Buried.connectDpm(110, 8, 1);
        const dcm = Buried.connectDcm(230, window['skinID'], 0);
        const embedDomain = DataManager.ins.petIndexData.embedDomain;
        const exposure = Buried.createExposure(dpm, dcm, embedDomain);
        NetManager.ins.showLog(exposure);

        this.init();
    }

    public updateData(): void {

        //设置签到ui初始
        this.setSignInDay();

    }

    public initEvents(): void {
        super.initEvents();

        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_hidePanel, this);

    }

    public removeEvents(): void {
        super.removeEvents();
        for (let i = 0; i < 7; i++) {
            this[`dayGroup${i}`].removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_signInBtn, this);
        }
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_hidePanel, this);
    }
    //轮询
    private pollingCheck(data: any): boolean {
        return data.result == 0;
    }

    // 设置签到ui初始
    private setSignInDay(): void {
        // 周期内连续签到天数
        const continueDay: number = Number(DataManager.ins.signInfoData.signInfoVO.continueDay);
        // 今日是否签到
        const todaySigned: boolean = DataManager.ins.signInfoData.signInfoVO.todaySigned;
        for (let i = 0; i < 7; i++) {
            if (i < continueDay) {
                this[`awardState${i}`].visible = true

            } else {
                this[`awardState${i}`].visible = false
            }
        }
        if (!todaySigned) {
            // 今日未签到
            this[`dayGroup${continueDay}`].addEventListener(egret.TouchEvent.TOUCH_BEGIN, () => {
                this[`dayGroup${continueDay}`].scaleX = 0.8;
                this[`dayGroup${continueDay}`].scaleY = 0.8;
            }, this);
            this[`dayGroup${continueDay}`].addEventListener(egret.TouchEvent.TOUCH_END, () => {
                this[`dayGroup${continueDay}`].scaleX = 1;
                this[`dayGroup${continueDay}`].scaleY = 1;
            }, this);
            this[`dayGroup${continueDay}`].addEventListener(egret.TouchEvent.TOUCH_CANCEL, () => {
                this[`dayGroup${continueDay}`].scaleX = 1;
                this[`dayGroup${continueDay}`].scaleY = 1;
            }, this);
            this[`dayGroup${continueDay}`].addEventListener(egret.TouchEvent.TOUCH_RELEASE_OUTSIDE, () => {
                this[`dayGroup${continueDay}`].scaleX = 1;
                this[`dayGroup${continueDay}`].scaleY = 1;
            }, this);
            this[`dayGroup${continueDay}`].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_signInBtn, this);

        }

        // this.signInBtn.enabled = !DataManager.ins.signInfoData.signInfoVO.todaySigned;
        // this.pMsgLb.text = '已连续签到' + acmDays + '天';
    }


    private onClick_signInBtn(e): void {
        Loading.instace.show();
        const target = e.$target;
        // 周期内连续签到天数
        let continueDay: number = Number(DataManager.ins.signInfoData.signInfoVO.continueDay);
        // 今日是否签到
        const todaySigned: boolean = DataManager.ins.signInfoData.signInfoVO.todaySigned;
        if (todaySigned) {
            PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, ["今天已经签过到了~"], false);
            return
        }
        NetManager.ins.doSign((s) => {
            Loading.instace.hide();
            if (!s) {
                //如果失败，按原先天数算进度？
                // PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, ["签到失败，请重试~"], false);
                return
            }
            console.log(DataManager.ins.signInfoData.signInfoVO);
            let continueDay = Number(DataManager.ins.signInfoData.signInfoVO.continueDay);
            if (continueDay > 0) {
                this[`dayGroup${continueDay - 1}`].removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_signInBtn, this);
            }
            if (continueDay > 7) {
                this[`dayGroup${continueDay}`].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_signInBtn, this);
            }


            for (let i = 0; i < 6; i++) {
                if (target == this[`btn${i}`]) {
                    this[`awardState${i}`].visible = true
                }
            }

            setTimeout(() => {
                let continueDay = Number(DataManager.ins.signInfoData.signInfoVO.continueDay);
                if (continueDay == 7) {
                    // 签到第七天 
                    if (DataManager.ins.signInfoData.signInfoVO.rewardMap && DataManager.ins.signInfoData.signInfoVO.rewardMap.CIRCLE && DataManager.ins.signInfoData.signInfoVO.rewardMap.CIRCLE.plActId) {
                        // 调用插件抽奖
                        const plugId: number = DataManager.ins.signInfoData.signInfoVO.rewardMap.CIRCLE.plActId;
                        Loading.instace.show();
                        NetManager.ins.doJoinPlugDraw((ss) => {
                            Loading.instace.hide();
                            if (!ss) {
                                // 失败弹窗
                                this.onClick_hidePanel();
                                PanelCtrl.instance.show(ModuleTypes.SIGN_IN_PRIZE_PANEL, false);
                                return
                            }
                            NetManager.ins.getPlugOrderStatus(
                                (sss) => {
                                    if (sss) {
                                        if (target == this[`btn6`]) {
                                            this[`awardState6`].visible = true
                                        }
                                        this.onClick_hidePanel();
                                        PanelCtrl.instance.show(ModuleTypes.SIGN_IN_PRIZE_PANEL, true)
                                    } else {
                                        this.onClick_hidePanel();
                                        PanelCtrl.instance.show(ModuleTypes.SIGN_IN_PRIZE_PANEL, false);
                                    }
                                },
                                DataManager.ins.doJoinPlugDrawData.orderId,
                                () => {
                                    return DataManager.ins.getPlugOrderStatusData.result == 0
                                }
                            )

                        }, plugId)
                    } else {
                        // 关闭弹窗 出奖品赶来弹窗
                        setTimeout(() => {
                            this.onClick_hidePanel();
                            PanelCtrl.instance.show(ModuleTypes.SIGN_IN_PRIZE_PANEL, false);
                        }, 500);
                    }
                } else {
                    // 关闭弹窗 出金币动画
                    this.onClick_hidePanel();
                    PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, ["签到成功"], false, 1000);
                    // 调用主页面更新积分动效方法

                    setTimeout(() => {
                        this.scene.signSucAni();
                    }, 1000);

                }
            }, 500);
        },
            window["signActivityId"]
        )
    }

    private onClick_hidePanel(): void {
        // if(this.guideBack){
        //     this.hideGuide();
        //     this.guideBack(3);
        // }
        super.hidePanel();
    }
}