import Panel from "../views/Panel";
import AlbumItem from "./AlbumItem";
import { DataManager } from "../../libs/tw/manager/DataManager";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import GuidePanel from "../guidePanel/GuidePanel";
/**
 * 相册界面
 */
export default class AlbumPanel extends Panel {
    public closeBtn: eui.Button;
    private con: eui.Group;
    private scroller: eui.Scroller;
    private itemList: AlbumItem[];

    // public guideBack: Function;
    public get skinKey() { return 'Album' }
	public get groupName() { return 'album_panel'}
    
    constructor(data?){
        super(data);
    }

	start(data?: any){
		// this.percentHeight = 100;

        // this.guideBack = data;
    }

    protected onSkinComplete():void{
        super.onSkinComplete();
        this.init();
    }

    private init():void{
        console.log('66666666');
        this.itemList = [];
        const rule = DataManager.ins.getCollectGoodsInfoData.collectGoods;
        let i = 0;
        for (const obj of rule) {
            if(obj.count > 0){
                this.itemList[i] = new AlbumItem(obj, i);
                this.con.addChild(this.itemList[i]);
                this.itemList[i].addEventListener(egret.TouchEvent.TOUCH_TAP, this.openInfo, this);
                i++;
            }
        }
        // this.con.width = 650;
        this.con.height = 1260;
        // this.con.x = 50;
        // this.con.bottom = 55;
        this.scroller = new eui.Scroller();
        this.scroller.viewport = this.con;
        this.addChild(this.scroller);
        this.scroller.x = 50;
        this.scroller.top = 180;
        // this.scroller.bottom = 55;
        i++;
        //相册被裁切的时候，容错高度
        var rect:eui.Rect = new eui.Rect(240, 240);
        this.con.addChild(rect);
        rect.y = Math.round(i / 3) * 240;
        rect.alpha = 0;
    }

    //打开相片
    openInfo(e:egret.TouchEvent):void{
        console.log('5555555');
        const d = e.currentTarget.data;
        const infoList = DataManager.ins.getCollectGoodsInfoData;
        const infoData = infoList.getCollectInfoByID(d.id);
        console.log('查看'+ infoData.name +'详情');
        PanelCtrl.instance.show(ModuleTypes.ALBUM_INFO_PANEL, infoData);
    }

    initEvents():void{
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_hidePanel, this);
    }

    removeEvents() {
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_hidePanel, this);
        for(let i=0; i<this.itemList.length; i++){
            this.itemList[i].removeEventListener(egret.TouchEvent.TOUCH_TAP, this.openInfo, this);
            this.con.removeChild(this.itemList[i]);
        }
    }

    onClick_hidePanel():void{
        super.hidePanel();
        // if(this.guideBack){
        //     this.guideBack(10);
        // }
    }
}