import { getSkinPath } from "../utils";
import ComponentBase from "../components/ComponentBase";

/**
 * 单个相片
 */
export default class AlbumItem extends ComponentBase {
    private img: eui.Image;
    private nameTxt: eui.Label;
    private countTxt: eui.Label;
    private index: number;
	public get skinKey() { return 'AlbumItem' }
    constructor(d:any, index?:number){
        super();
        this.data = d;
        this.index = index;
    }
    
    private init():void{
        this.updateData();
    }

    protected onSkinComplete():void{
        this.init();
    }

    updateData():void{
        if(this.data){
            this.x = (this.index % 3) * 225;
            this.y = Math.floor(this.index / 3) * 240;
            this.nameTxt.text = this.data.name;
            this.countTxt.text = '游玩' + this.data.count + '次';
            this.img.source = this.data.img;
        }
    }

}