import { HtmlTextParser } from './../../libs/tc/util/HtmlTextParser';
import Panel from "../views/Panel";
import AlbumItem from "./AlbumItem";
import { DataManager } from "../../libs/tw/manager/DataManager";
/**
 * 相片详情界面
 */
export default class AlbumInfoPanel extends Panel {
    private closeBtn: eui.Button;
    private img: eui.Image;
    private nameTxt: eui.Label;
    private descTxt: eui.Label;

    private d: any;
	public get skinKey() { return 'AlbumInfo' }
    constructor(data?){
        super(data);
    }

	start(data?: any){
        this.percentHeight = 100;
        this.d = data;
    }

    protected onSkinComplete():void{
        super.onSkinComplete();
        this.init();
        if(this.d){
            this.img.source = this.d.img;
            this.nameTxt.text = this.d.name;
            this.descTxt.textFlow = HtmlTextParser.ins.parser(this.d.itemDesc);
            console.log('this.descTxt.textFlow=',this.descTxt.textFlow);
        }
        
        
    }

    private init():void{

    }

    initEvents():void{
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.hidePanel, this);
    }

    removeEvents() {
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.hidePanel, this);
    }
}